/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class MappingRegionAnalysis {
    protected final @NonNull MappingRegion mappingRegion;
    private @Nullable List<@NonNull Node> stronglyMatchedNodes = null;
    private @Nullable List<@NonNull Node> unconditionalNodes = null;
    private @Nullable List<@NonNull Node> conditionalNodes = null;
    private @Nullable List<@NonNull Node> deadNodes = null;

    public static void initHeadNodes(@NonNull MappingRegion mappingRegion, @Nullable List<@NonNull Node> preferredHeadNodes) {
        MappingRegionAnalysis mappingRegionAnalysis = new MappingRegionAnalysis(mappingRegion);
        mappingRegionAnalysis.initHeadNodes(preferredHeadNodes);
    }

    public MappingRegionAnalysis(@NonNull MappingRegion mappingRegion) {
        this.mappingRegion = mappingRegion;
    }

    private boolean canBeStronglyMatched(@NonNull Node node) {
        if (node.isExplicitNull()) {
            return true;
        }
        return node.isPattern();
    }

    private boolean canBeUnconditional(@NonNull Node node) {
        if (node.isExplicitNull()) {
            return true;
        }
        if (node.isIterator()) {
            return false;
        }
        if (node.isOperation()) {
            return true;
        }
        return node.isPattern();
    }

    private @NonNull Set<@NonNull Node> computeConditionalNodes(@NonNull Set<@NonNull Node> unconditionalNodes) {
        HashSet<@NonNull Node> conditionalNodes = new HashSet<Node>();
        Set<@NonNull Node> moreNodes = unconditionalNodes;
        while (moreNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node node : moreNodes) {
                for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Node sourceNode = incomingEdge.getEdgeSource();
                    if (unconditionalNodes.contains(sourceNode) || !conditionalNodes.add(sourceNode)) continue;
                    moreMoreNodes.add(sourceNode);
                }
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                    Node targetNode = outgoingEdge.getEdgeTarget();
                    if (unconditionalNodes.contains(targetNode) || !conditionalNodes.add(targetNode)) continue;
                    moreMoreNodes.add(targetNode);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreNodes = moreMoreNodes;
        }
        this.conditionalNodes = new ArrayList<Node>(conditionalNodes);
        Collections.sort(this.conditionalNodes, NameUtil.NAMEABLE_COMPARATOR);
        return conditionalNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull Node> computeHeadNodes(@NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources, @Nullable List<@NonNull Node> preferredHeadNodes) {
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourcesClosure = targetFromSources;
        Set<@NonNull Node> navigableNodes = targetFromSourcesClosure.keySet();
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (Node targetNode : navigableNodes) {
                Set<Node> sourcesClosure = targetFromSourcesClosure.get(targetNode);
                assert (sourcesClosure != null);
                for (Node sourceNode : new ArrayList(sourcesClosure)) {
                    Set<@NonNull Node> set = targetFromSourcesClosure.get(sourceNode);
                    assert (set != null);
                    if (!sourcesClosure.addAll(set)) continue;
                    isChanged = true;
                }
            }
        }
        HashMap<@NonNull Node, @NonNull @NonNull HashSet> source2targetsClosure = new HashMap<Node, HashSet>();
        for (Node sourceNode : navigableNodes) {
            source2targetsClosure.put(sourceNode, Sets.newHashSet((Object[])new Node[]{sourceNode}));
        }
        for (Node targetNode : targetFromSourcesClosure.keySet()) {
            Set<@NonNull Node> sourcesClosure = targetFromSourcesClosure.get(targetNode);
            assert (sourcesClosure != null);
            for (Node sourceNode : sourcesClosure) {
                @NonNull Set targetClosure = (Set)source2targetsClosure.get(sourceNode);
                assert (targetClosure != null);
                targetClosure.add(targetNode);
            }
        }
        ArrayList<@NonNull E> headLessNodes = new ArrayList();
        Iterables.addAll(headLessNodes, targetFromSourcesClosure.keySet());
        Collections.sort(headLessNodes, new HeadComparator(targetFromSourcesClosure, preferredHeadNodes));
        ArrayList<@NonNull HeadNodeGroup> headNodeGroups = new ArrayList<HeadNodeGroup>();
        HashSet<@NonNull Node> reachableNodes = new HashSet<Node>();
        while (!headLessNodes.isEmpty()) {
            Node headNode = (Node)headLessNodes.remove(0);
            assert (headNode != null);
            ArrayList<@NonNull Node> arrayList = new ArrayList<Node>();
            arrayList.add(headNode);
            Set<@NonNull Node> debugSourceClosure = targetFromSourcesClosure.get(headNode);
            Set targetsClosure = (Set)source2targetsClosure.get(headNode);
            assert (targetsClosure != null);
            Iterator iterator = targetsClosure.iterator();
            while (iterator.hasNext()) {
                @NonNull Node targetNode = (Node)iterator.next();
                if (!reachableNodes.add(targetNode)) continue;
                headLessNodes.remove(targetNode);
                if (targetNode == headNode) continue;
                @NonNull Set otherTargetsClosure = (Set)source2targetsClosure.get(targetNode);
                assert (otherTargetsClosure != null);
                if (!otherTargetsClosure.contains(headNode)) continue;
                arrayList.add(targetNode);
            }
            headNodeGroups.add(new HeadNodeGroup(arrayList));
        }
        if (headNodeGroups.size() > 1) {
            int iGroup = headNodeGroups.size() - 1;
            while (iGroup >= 0) {
                HeadNodeGroup headNodeGroup = (HeadNodeGroup)headNodeGroups.get(iGroup);
                for (HeadNodeGroup otherHeadNodeGroup : headNodeGroups) {
                    if (otherHeadNodeGroup == headNodeGroup || !headNodeGroup.isDeriveableFrom(otherHeadNodeGroup)) continue;
                    headNodeGroups.remove(iGroup);
                    break;
                }
                --iGroup;
            }
        }
        ArrayList<@NonNull Node> headNodes = new ArrayList<Node>();
        for (HeadNodeGroup headNodeGroup : headNodeGroups) {
            Node headNode = headNodeGroup.getPreferredHeadNode();
            assert (!headNodes.contains(headNode));
            headNodes.add(headNode);
        }
        assert (reachableNodes.equals(targetFromSourcesClosure.keySet()));
        for (Node node : reachableNodes) {
            if (headNodes.contains(node)) {
                node.setHead();
                continue;
            }
            node.resetHead();
        }
        return headNodes;
    }

    private @NonNull Set<@NonNull Node> computeStronglyMatchedNodes(@NonNull Iterable<@NonNull Node> headNodes) {
        HashSet<@NonNull Node> stronglyMatchedNodes = new HashSet<Node>();
        for (Node headNode : headNodes) {
            if (headNode.isDependency() || headNode.isTrue()) continue;
            stronglyMatchedNodes.add(headNode);
        }
        HashSet<@NonNull E> moreStronglyMatchedNodes = new HashSet(stronglyMatchedNodes);
        while (moreStronglyMatchedNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node sourceNode : moreStronglyMatchedNodes) {
                for (NavigableEdge edge : sourceNode.getNavigationEdges()) {
                    Node targetNode = edge.getEdgeTarget();
                    if (!this.canBeStronglyMatched(targetNode) || !targetNode.isExplicitNull() && !edge.getProperty().isIsRequired() || !stronglyMatchedNodes.add(targetNode)) continue;
                    moreMoreNodes.add(targetNode);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreStronglyMatchedNodes = moreMoreNodes;
        }
        this.stronglyMatchedNodes = new ArrayList<Node>(stronglyMatchedNodes);
        Collections.sort(this.stronglyMatchedNodes, NameUtil.NAMEABLE_COMPARATOR);
        return stronglyMatchedNodes;
    }

    protected @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> computeTargetFromSources(@NonNull Iterable<@NonNull Node> navigableNodes) {
        HashMap<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure = new HashMap<Node, Set<Node>>();
        for (Node targetNode : navigableNodes) {
            targetFromSourceClosure.put(targetNode, Sets.newHashSet((Object[])new Node[]{targetNode}));
        }
        for (Node sourceNode : navigableNodes) {
            for (Edge navigationEdge : sourceNode.getNavigationEdges()) {
                Set sourceClosure;
                Node targetNode;
                if (navigationEdge.isRealized() || !(targetNode = navigationEdge.getEdgeTarget()).isMatched() || targetNode.isExplicitNull() || (sourceClosure = (Set)targetFromSourceClosure.get(targetNode)) == null) continue;
                sourceClosure.add(sourceNode);
            }
        }
        return targetFromSourceClosure;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Set<@NonNull Node> computeUnconditionalNodes(@NonNull Iterable<@NonNull Node> headNodes) {
        @NonNull @NonNull HashSet unconditionalNodes = Sets.newHashSet(headNodes);
        Iterables.addAll((Collection)unconditionalNodes, (Iterable)this.mappingRegion.getNewNodes());
        for (NavigableEdge edge : this.mappingRegion.getRealizedNavigationEdges()) {
            if (edge.isSecondary()) continue;
            Node sourceNode = edge.getEdgeSource();
            assert (this.canBeUnconditional(sourceNode));
            unconditionalNodes.add(sourceNode);
            Node targetNode = edge.getEdgeTarget();
            assert (this.canBeUnconditional(targetNode));
            unconditionalNodes.add(targetNode);
        }
        HashSet<@NonNull E> moreUnconditionalNodes = new HashSet(unconditionalNodes);
        while (moreUnconditionalNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node node : moreUnconditionalNodes) {
                for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Node sourceNode = incomingEdge.getEdgeSource();
                    if (!this.canBeUnconditional(sourceNode)) continue;
                    if (incomingEdge.isComputation()) {
                        if (this.isConditionalEdge(incomingEdge) || !unconditionalNodes.add(sourceNode)) continue;
                        moreMoreNodes.add(sourceNode);
                        continue;
                    }
                    if (incomingEdge.isNavigation()) {
                        if (!unconditionalNodes.add(sourceNode)) continue;
                        moreMoreNodes.add(sourceNode);
                        continue;
                    }
                    System.out.println("Unsupported incoming edge in " + this + " : " + incomingEdge);
                }
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                    Node targetNode = outgoingEdge.getEdgeTarget();
                    if (!this.canBeUnconditional(targetNode) || outgoingEdge.isComputation()) continue;
                    if (outgoingEdge.isNavigation()) {
                        if (targetNode.isExplicitNull()) {
                            if (!unconditionalNodes.add(targetNode)) continue;
                            moreMoreNodes.add(targetNode);
                            continue;
                        }
                        if (!node.isRequired() || !((NavigableEdge)outgoingEdge).getProperty().isIsRequired() || !unconditionalNodes.add(targetNode)) continue;
                        moreMoreNodes.add(targetNode);
                        continue;
                    }
                    System.out.println("Unsupported outgoing edge in " + this + " : " + outgoingEdge);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreUnconditionalNodes = moreMoreNodes;
        }
        this.unconditionalNodes = new ArrayList<Node>(unconditionalNodes);
        Collections.sort(this.unconditionalNodes, NameUtil.NAMEABLE_COMPARATOR);
        return unconditionalNodes;
    }

    public void computeUtilities(@NonNull Iterable<@NonNull Node> headNodes) {
        Set<@NonNull Node> stronglyMatchedNodes = this.computeStronglyMatchedNodes(headNodes);
        Set<@NonNull Node> unconditionalNodes = this.computeUnconditionalNodes(headNodes);
        Set<@NonNull Node> conditionalNodes = this.computeConditionalNodes(unconditionalNodes);
        HashSet<Node> deadNodes = null;
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (stronglyMatchedNodes.contains(node)) {
                node.setUtility(Node.Utility.STRONGLY_MATCHED);
                assert (unconditionalNodes.contains(node));
                continue;
            }
            if (unconditionalNodes.contains(node) && !node.isDependency()) {
                node.setUtility(Node.Utility.WEAKLY_MATCHED);
                continue;
            }
            if (conditionalNodes.contains(node)) {
                node.setUtility(Node.Utility.CONDITIONAL);
                continue;
            }
            if (node.isDependency()) {
                node.setUtility(Node.Utility.DEPENDENCY);
                continue;
            }
            System.out.println("Dead node in " + this + " : " + node);
            if (deadNodes == null) {
                deadNodes = new HashSet<Node>();
            }
            deadNodes.add(node);
            node.setUtility(Node.Utility.DEAD);
            this.toString();
        }
        if (deadNodes != null) {
            this.deadNodes = new ArrayList<Node>(deadNodes);
            Collections.sort(this.deadNodes, NameUtil.NAMEABLE_COMPARATOR);
        }
    }

    public @NonNull List<@NonNull Node> initHeadNodes(@Nullable List<@NonNull Node> preferredHeadNodes) {
        ArrayList<@NonNull Node> navigableNodes = new ArrayList<Node>();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (!node.isPattern() || !node.isMatched() || !node.isClass() || node.isExplicitNull() || node.isOperation() || !node.isLoaded() && !node.isPredicated() && !node.isSpeculated()) continue;
            navigableNodes.add(node);
        }
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources = this.computeTargetFromSources(navigableNodes);
        List<@NonNull Node> headNodes = this.computeHeadNodes(targetFromSources, preferredHeadNodes);
        HashSet<@NonNull Node> debugHeadNodes = new HashSet<Node>();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (node.isTrue() || node.isDependency()) {
                debugHeadNodes.add(node);
                node.setHead();
                assert (!headNodes.contains(node));
                headNodes.add(node);
                continue;
            }
            if (!node.isHead()) continue;
            debugHeadNodes.add(node);
        }
        assert (debugHeadNodes.equals(new HashSet<Node>(headNodes)));
        this.mappingRegion.getHeadNodes().addAll(headNodes);
        return headNodes;
    }

    private boolean isConditionalEdge(@NonNull Edge edge) {
        String edgeName = edge.getName();
        return "\u00abthen\u00bb".equals(edgeName) || "\u00abelse\u00bb".equals(edgeName) || "\u00abbody\u00bb".equals(edgeName);
    }

    public String toString() {
        return this.mappingRegion.toString();
    }

    protected static class HeadComparator
    implements Comparator<Node> {
        private final @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure;
        private final @Nullable List<@NonNull Node> preferredHeadNodes;
        private @Nullable Map<@NonNull Node, @NonNull Integer> node2implicity = null;

        public HeadComparator(@NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure, @Nullable List<@NonNull Node> preferredHeadNodes) {
            this.targetFromSourceClosure = targetFromSourceClosure;
            this.preferredHeadNodes = preferredHeadNodes;
        }

        @Override
        public int compare(@NonNull Node o1, @NonNull Node o2) {
            int i2;
            boolean c2;
            int l2;
            int i22;
            int i1;
            boolean d2;
            boolean d1 = o1.isDataType();
            if (d1 != (d2 = o2.isDataType())) {
                return d1 ? 1 : -1;
            }
            List<@NonNull Node> preferredHeadNodes2 = this.preferredHeadNodes;
            if (preferredHeadNodes2 != null && (i1 = preferredHeadNodes2.indexOf(o1)) != (i22 = preferredHeadNodes2.indexOf(o2))) {
                if (i1 < 0) {
                    return 1;
                }
                if (i22 < 0) {
                    return -1;
                }
                return i1 - i22;
            }
            if (o1.isSpeculated() != o2.isSpeculated()) {
                return o1.isSpeculated() ? -1 : 1;
            }
            if (o1.isConstant() != o2.isConstant()) {
                return o1.isConstant() ? -1 : 1;
            }
            Set<@NonNull Node> set1 = this.targetFromSourceClosure.get(o1);
            Set<@NonNull Node> set2 = this.targetFromSourceClosure.get(o2);
            assert (set1 != null && set2 != null);
            int l1 = set1.size();
            int diff = l1 - (l2 = set2.size());
            if (diff != 0) {
                return diff;
            }
            if (o1.isLoaded() != o2.isLoaded()) {
                return o1.isLoaded() ? -1 : 1;
            }
            if (o1.isPredicated() != o2.isPredicated()) {
                return o1.isPredicated() ? -1 : 1;
            }
            boolean c1 = QVTscheduleUtil.getCastTarget((Node)o1) != o1;
            boolean bl = c2 = QVTscheduleUtil.getCastTarget((Node)o2) != o2;
            if (c1 != c2) {
                return !c1 ? -1 : 1;
            }
            int i12 = this.getImplicity(o1);
            diff = i12 - (i2 = this.getImplicity(o2));
            if (diff != 0) {
                return diff;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }

        private int getImplicity(@NonNull Node node) {
            Integer implicity;
            Map<@NonNull Node, @NonNull Integer> node2implicity2 = this.node2implicity;
            if (node2implicity2 == null) {
                this.node2implicity = node2implicity2 = new HashMap<Node, Integer>();
            }
            if ((implicity = node2implicity2.get(node)) == null) {
                implicity = 0;
                for (NavigableEdge e : node.getNavigationEdges()) {
                    if (!e.getProperty().isIsImplicit()) continue;
                    implicity = implicity + 1;
                }
                node2implicity2.put(node, implicity);
            }
            return implicity;
        }
    }

    public class HeadNodeGroup {
        private final @NonNull List<@NonNull Node> headNodes;
        private Set<@NonNull Node> missingNodes = null;
        private List<@NonNull Node> toOneList = null;
        private Set<@NonNull Node> toOneSet = null;
        private List<@NonNull Node> toManyList = null;
        private Set<@NonNull Node> toManySet = null;

        public HeadNodeGroup(List<Node> headNodes) {
            this.headNodes = headNodes;
        }

        public @NonNull Iterable<@NonNull Node> getHeadNodes() {
            return this.headNodes;
        }

        public @NonNull Node getPreferredHeadNode() {
            return this.headNodes.get(0);
        }

        /*
         * Unable to fully structure code
         */
        private void computeReachables() {
            this.missingNodes = new HashSet<Node>();
            this.toOneList = new ArrayList<Node>(this.headNodes);
            this.toOneSet = new HashSet<Node>(this.headNodes);
            this.toManyList = new ArrayList<Node>();
            this.toManySet = new HashSet<Node>();
            iToOne = 0;
            iToMany = 0;
            ** GOTO lbl16
            {
                toOneNode = this.toOneList.get(iToOne++);
                this.computeReachable(toOneNode);
                do {
                    if (iToOne < this.toOneList.size()) continue block0;
                    if (iToMany >= this.toManyList.size()) continue;
                    toManyNode = this.toManyList.get(iToMany++);
                    this.computeReachable(toManyNode);
lbl16:
                    // 3 sources

                } while (iToOne < this.toOneList.size() || iToMany < this.toManyList.size());
            }
        }

        private void computeReachable(@NonNull Node node) {
            for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                TypedElement typedElement;
                Iterable typedElements;
                if (!outgoingEdge.isOld()) continue;
                Type sourceType = null;
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)outgoingEdge);
                if (outgoingEdge.isNavigation()) {
                    Property targetProperty = QVTscheduleUtil.getProperty((NavigableEdge)((NavigableEdge)outgoingEdge));
                    sourceType = targetProperty.getType();
                } else if (!outgoingEdge.isPredicate() && outgoingEdge.isComputation() && !this.toOneSet.contains(targetNode) && !this.toManySet.contains(targetNode)) {
                    boolean reachable = true;
                    for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                        Node sourceNode;
                        if (incomingEdge == outgoingEdge || !incomingEdge.isComputation() || (sourceNode = QVTscheduleUtil.getSourceNode((Edge)incomingEdge)).isConstant() || this.toOneSet.contains(sourceNode) || this.toManySet.contains(sourceNode)) continue;
                        this.missingNodes.add(sourceNode);
                        reachable = false;
                    }
                    if (reachable && !Iterables.isEmpty((Iterable)(typedElements = targetNode.getTypedElements()))) {
                        typedElement = (TypedElement)typedElements.iterator().next();
                        sourceType = typedElement.getType();
                    }
                }
                if (sourceType == null) continue;
                Type nodeType = null;
                typedElements = targetNode.getTypedElements();
                if (!Iterables.isEmpty((Iterable)typedElements)) {
                    typedElement = (TypedElement)typedElements.iterator().next();
                    nodeType = typedElement.getType();
                }
                if (sourceType instanceof CollectionType || nodeType instanceof CollectionType) {
                    if (this.toOneSet.contains(targetNode) || !this.toManySet.add(targetNode)) continue;
                    this.toManyList.add(targetNode);
                    this.missingNodes.remove(targetNode);
                    continue;
                }
                if (!this.toOneSet.add(targetNode)) continue;
                this.toOneList.add(targetNode);
                this.missingNodes.remove(targetNode);
            }
        }

        public boolean isDeriveableFrom(@NonNull HeadNodeGroup thatHeadNodeGroup) {
            return thatHeadNodeGroup.getToOneList().containsAll(this.headNodes);
        }

        private @NonNull List<@NonNull Node> getToOneList() {
            List<@NonNull Node> toOneList2 = this.toOneList;
            if (toOneList2 == null) {
                this.computeReachables();
                toOneList2 = this.toOneList;
                assert (toOneList2 != null);
            }
            return toOneList2;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(MappingRegionAnalysis.this.mappingRegion);
            s.append("\n\theads:");
            for (Node node : this.headNodes) {
                s.append("\n\t\t");
                s.append(node);
            }
            if (this.toOneList != null) {
                s.append("\n\tto-ones:");
                for (Node node : this.toOneList) {
                    s.append("\n\t\t");
                    s.append(node);
                }
            }
            if (this.toManyList != null) {
                s.append("\n\tto-manys:");
                for (Node node : this.toManyList) {
                    s.append("\n\t\t");
                    s.append(node);
                }
            }
            if (this.missingNodes != null) {
                s.append("\n\tmissings:");
                for (Node node : this.missingNodes) {
                    s.append("\n\t\t");
                    s.append(node);
                }
            }
            return s.toString();
        }
    }
}

