/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import com.google.common.base.Objects;
import org.eclipse.eef.EEFLabelDescription;
import org.eclipse.eef.EEFLabelStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFLabelController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFLabelLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int LABEL_WIDTH_HINT = 300;
    private EEFLabelDescription description;
    private StyledText body;
    private IEEFLabelController controller;

    public EEFLabelLifecycleManager(EEFLabelDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.body = widgetFactory.createStyledText(parent, 64);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.heightHint = this.body.getLineHeight();
        gridData.widthHint = 300;
        gridData.horizontalIndent = 5;
        this.body.setLayoutData((Object)gridData);
        this.body.setEditable(false);
        this.controller = new EEFControllersFactory().createLabelController(this.description, this.variableManager, this.interpreter);
    }

    @Override
    protected int getLabelVerticalAlignment() {
        return 4;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.controller.onNewValue((IConsumer)new IConsumer<String>(){

            public void apply(String value) {
                if (!EEFLabelLifecycleManager.this.body.isDisposed()) {
                    if (EEFLabelLifecycleManager.this.body.getText() == null || !EEFLabelLifecycleManager.this.body.getText().equals(value)) {
                        EEFLabelLifecycleManager.this.body.setText((String)Objects.firstNonNull((Object)value, (Object)""));
                    }
                    EEFLabelLifecycleManager.this.setStyle();
                }
            }
        });
    }

    private void setStyle() {
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle style = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (style instanceof EEFLabelStyle) {
            EEFLabelStyle labelStyle = (EEFLabelStyle)style;
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.body);
            styleHelper.applyTextStyle(labelStyle.getFontNameExpression(), labelStyle.getFontSizeExpression(), labelStyle.getFontStyleExpression(), this.body.getFont(), labelStyle.getBackgroundColorExpression(), labelStyle.getForegroundColorExpression(), callback);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.body.setEnabled(this.isEnabled());
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        this.controller.removeNewValueConsumer();
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    protected Control getValidationControl() {
        return this.body;
    }
}

