/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.tasks;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.tasks.SingleCpaTaskResultContainer;
import org.eclipse.emf.henshin.multicda.cpa.CDAOptions;
import org.eclipse.emf.henshin.multicda.cpa.CpaByAGG;
import org.eclipse.emf.henshin.multicda.cpa.ICriticalPairAnalysis;
import org.eclipse.emf.henshin.multicda.cpa.result.CPAResult;

public class CalculateCpaTask
implements Callable<CPAResult> {
    List<Rule> firstRuleList;
    List<Rule> secondRuleList;
    CDAOptions cpaOptions;
    AnalysisKind analysisKind;
    ICriticalPairAnalysis criticalPairAnalysis;
    long normalRunTime;
    SingleCpaTaskResultContainer taskResultContainer;

    public CalculateCpaTask(SingleCpaTaskResultContainer taskResultContainer, AnalysisKind analysisKind) {
        this.taskResultContainer = taskResultContainer;
        this.analysisKind = analysisKind;
        this.firstRuleList = taskResultContainer.getFirstRuleList();
        this.secondRuleList = taskResultContainer.getSecondRuleList();
        this.cpaOptions = taskResultContainer.getCpaOptions();
        this.criticalPairAnalysis = new CpaByAGG();
    }

    @Override
    public CPAResult call() throws Exception {
        CPAResult cpaResult = null;
        long normalStartTime = System.currentTimeMillis();
        try {
            this.criticalPairAnalysis.init(new HashSet<Rule>(this.firstRuleList), new HashSet<Rule>(this.secondRuleList), this.cpaOptions);
            cpaResult = this.analysisKind == AnalysisKind.CONFLICT ? this.criticalPairAnalysis.runConflictAnalysis() : this.criticalPairAnalysis.runDependencyAnalysis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long cpaEndTime = System.currentTimeMillis();
        this.normalRunTime = cpaEndTime - normalStartTime;
        this.taskResultContainer.setResult(cpaResult, this.normalRunTime);
        return cpaResult;
    }

    public static enum AnalysisKind {
        CONFLICT,
        DEPENDENCY;

    }
}

