/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace;

import java.util.ArrayDeque;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.Transition;

public class Path
extends ArrayDeque<Transition> {
    private static final long serialVersionUID = 1L;
    private State state;

    public Path() {
    }

    public Path(State state) {
        this.setState(state);
    }

    public Path(Transition ... transitions) {
        Transition[] transitionArray = transitions;
        int n = transitions.length;
        int n2 = 0;
        while (n2 < n) {
            Transition transition = transitionArray[n2];
            this.addLast(transition);
            ++n2;
        }
    }

    public State getSource() {
        return this.isEmpty() ? this.state : ((Transition)this.getFirst()).getSource();
    }

    public State getTarget() {
        return this.isEmpty() ? this.state : ((Transition)this.getLast()).getTarget();
    }

    public void setState(State state) {
        this.state = state;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "empty";
        }
        String result = "";
        boolean first = true;
        for (Transition t : this) {
            if (first) {
                result = String.valueOf(t.getSource().getIndex());
            }
            result = String.valueOf(result) + " --" + t.getLabel() + "--> " + t.getTarget().getIndex();
            first = false;
        }
        return result;
    }
}

