/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.henshin.statespace.Path;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpaceValidator;
import org.eclipse.emf.henshin.statespace.StateValidator;
import org.eclipse.emf.henshin.statespace.ValidationResult;
import org.eclipse.emf.henshin.statespace.util.StateSpaceShortestPath;

public class ShortestPathStateSpaceValidator
implements StateSpaceValidator {
    private StateValidator validator;

    public ShortestPathStateSpaceValidator(StateValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException();
        }
        this.validator = validator;
    }

    @Override
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Finding shortest path...", stateSpace.getStateCount() * 2);
        ArrayList<State> targetStates = new ArrayList<State>();
        for (State state : stateSpace.getStates()) {
            if (monitor.isCanceled()) {
                return null;
            }
            ValidationResult result = this.validator.validate(state, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (result.isValid()) {
                targetStates.add(state);
            }
            monitor.worked(1);
        }
        if (targetStates.isEmpty()) {
            monitor.done();
            return new ValidationResult(false, "No matching state found.");
        }
        StateSpaceShortestPath shortestPath = new StateSpaceShortestPath();
        shortestPath.computeShortestPaths((List<State>)stateSpace.getInitialStates());
        Path shortest = null;
        for (State target : targetStates) {
            Path path = shortestPath.getShortestPath(target);
            if (shortest != null && (path == null || path.size() >= shortest.size())) continue;
            shortest = path;
        }
        if (shortest == null) {
            monitor.done();
            return new ValidationResult(false, "No matching state reachable.");
        }
        monitor.done();
        return new ValidationResult(true, "Shortest path of length " + shortest.size() + " found (target state " + shortest.getTarget() + ").", shortest);
    }

    @Override
    public String getName() {
        return String.valueOf(this.validator.getName()) + " (shortest path)";
    }

    @Override
    public void setProperty(String property) throws ParseException {
        this.validator.setProperty(property);
    }

    @Override
    public void setStateSpaceIndex(StateSpaceIndex index) {
        this.validator.setStateSpaceIndex(index);
    }

    @Override
    public boolean usesProperty() {
        return true;
    }
}

