/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Constraint;

public class DanglingConstraint
implements Constraint {
    public Map<EReference, Integer> outgoingEdgeCount;
    public Map<EReference, Integer> incomingEdgeCount;
    public boolean postpone;

    public DanglingConstraint(Map<EReference, Integer> outgoingEdgeCount, Map<EReference, Integer> incomingEdgeCount, boolean postpone) {
        this.outgoingEdgeCount = outgoingEdgeCount;
        this.incomingEdgeCount = incomingEdgeCount;
        this.postpone = postpone;
    }

    public boolean check(EObject sourceValue, EGraph graph) {
        Integer expectedCount;
        Collection settings = graph.getCrossReferenceAdapter().getInverseReferences(sourceValue);
        Map<EReference, Integer> actualIncomingEdges = this.createMapFromSettings(settings, graph);
        if (this.incomingEdgeCount != null) {
            for (EReference ref : actualIncomingEdges.keySet()) {
                expectedCount = this.incomingEdgeCount.containsKey(ref) ? this.incomingEdgeCount.get(ref) : Integer.valueOf(0);
                if (actualIncomingEdges.get(ref) <= expectedCount) continue;
                return false;
            }
        } else if (!actualIncomingEdges.isEmpty()) {
            return false;
        }
        for (EReference type : sourceValue.eClass().getEReferences()) {
            if (type.isDerived()) continue;
            expectedCount = this.outgoingEdgeCount != null && this.outgoingEdgeCount.containsKey(type) ? this.outgoingEdgeCount.get(type) : Integer.valueOf(0);
            if (type.isMany()) {
                List outgoingEdges = (List)sourceValue.eGet((EStructuralFeature)type);
                outgoingEdges.retainAll(graph);
                if (expectedCount == null || expectedCount.intValue() == outgoingEdges.size()) continue;
                return false;
            }
            if (sourceValue.eGet((EStructuralFeature)type) == null || expectedCount == 1 || !graph.contains(sourceValue.eGet((EStructuralFeature)type))) continue;
            return false;
        }
        return true;
    }

    private Map<EReference, Integer> createMapFromSettings(Collection<EStructuralFeature.Setting> settings, EGraph graph) {
        HashMap<EReference, Integer> result = new HashMap<EReference, Integer>();
        for (EStructuralFeature.Setting setting : settings) {
            if (!graph.contains(setting.getEObject())) continue;
            Integer count = (Integer)result.get(setting.getEStructuralFeature());
            if (count == null) {
                count = 1;
                EStructuralFeature feature = setting.getEStructuralFeature();
                if (feature.isDerived()) continue;
                result.put((EReference)feature, count);
                continue;
            }
            count = count + 1;
        }
        return result;
    }

    public DanglingConstraint copy() {
        HashMap<EReference, Integer> outgoingEdgeCount2 = null;
        if (this.outgoingEdgeCount != null) {
            outgoingEdgeCount2 = new HashMap<EReference, Integer>();
            outgoingEdgeCount2.putAll(this.outgoingEdgeCount);
        }
        HashMap<EReference, Integer> incomingEdgeCount2 = null;
        if (this.incomingEdgeCount != null) {
            incomingEdgeCount2 = new HashMap<EReference, Integer>();
            incomingEdgeCount2.putAll(this.incomingEdgeCount);
        }
        return new DanglingConstraint(outgoingEdgeCount2, incomingEdgeCount2, this.postpone);
    }

    public void increaseOutgoing(EReference ref, int count) {
        if (this.outgoingEdgeCount == null) {
            this.outgoingEdgeCount = new HashMap<EReference, Integer>();
        }
        if (this.outgoingEdgeCount.get(ref) == null) {
            this.outgoingEdgeCount.put(ref, count);
        } else {
            int newCount = this.outgoingEdgeCount.get(ref) + count;
            this.outgoingEdgeCount.put(ref, newCount);
        }
    }

    public void increaseIncoming(EReference ref, int count) {
        if (this.incomingEdgeCount == null) {
            this.incomingEdgeCount = new HashMap<EReference, Integer>();
        }
        if (this.incomingEdgeCount.get(ref) == null) {
            this.incomingEdgeCount.put(ref, count);
        } else {
            int newCount = this.incomingEdgeCount.get(ref) + count;
            this.incomingEdgeCount.put(ref, newCount);
        }
    }
}

