/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.printer.actions;

import java.io.File;
import nestedcondition.NestedConstraint;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.CoreCommand;
import org.eclipse.emf.henshin.ocl2ac.utils.printer.NestedConditionPrinter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class NGCPrintOpenActionShortVersion
implements IObjectActionDelegate {
    protected IWorkbenchPart workbenchPart;
    protected NestedConstraint constraint;
    private CoreCommand wincmd;

    public void run(IAction action) {
        this.print();
    }

    protected void print() {
        if (this.constraint != null) {
            NestedConditionPrinter nestedConditionPrinter = new NestedConditionPrinter(this.constraint, true);
            nestedConditionPrinter.printDocument();
            final String filepath = nestedConditionPrinter.getOutputFilePath();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    System.out.println("Thread Running");
                    NGCPrintOpenActionShortVersion.this.compileLatex2PDF(filepath);
                    File texFile = new File(filepath);
                    int lastIndexOf = texFile.getName().lastIndexOf(".tex");
                    String pdfFileName = texFile.getName().substring(0, lastIndexOf).concat(".pdf");
                    File pdfFile = new File(texFile.getParent(), pdfFileName);
                    System.err.println(pdfFile.getPath());
                    if (!pdfFile.exists()) {
                        System.err.println("The PDF file of the generated latex is not produced.");
                    } else {
                        NGCPrintOpenActionShortVersion.this.openPDF(pdfFile);
                    }
                }
            };
            thread.start();
        }
    }

    private void compileLatex2PDF(String filePath) {
        Path p = new Path(filePath);
        this.wincmd = new CoreCommand();
        this.wincmd.executePDFLatexCommand(p.toOSString(), p.toFile().getParent());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        this.constraint = null;
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof NestedConstraint) {
            this.constraint = (NestedConstraint)first;
            System.out.println(String.valueOf(this.constraint.getName()) + " " + this.constraint.eClass().getEPackage().getName());
        }
        action.setEnabled(this.constraint != null);
    }

    private void openPDF(File pdfFile) {
        if (pdfFile.exists()) {
            this.wincmd = new CoreCommand();
            this.wincmd.desktopRun(pdfFile);
        } else {
            System.out.println("The PDF file is not found");
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
    }
}

