/*
 * Decompiled with CFR 0.152.
 */
package mergeSuggestion.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import mergeSuggestion.MergeNAC;
import mergeSuggestion.MergePAC;
import mergeSuggestion.MergeRule;
import mergeSuggestion.MergeRuleElement;
import mergeSuggestion.MergeSuggestionPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.Rule;

public class MergeRuleImpl
extends MinimalEObjectImpl.Container
implements MergeRule {
    protected Rule masterRule;
    protected EList<Rule> rules;
    protected EList<MergeRuleElement> elements;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<MergeNAC> mergeNacs;
    protected EList<MergePAC> mergePacs;

    protected MergeRuleImpl() {
    }

    protected EClass eStaticClass() {
        return MergeSuggestionPackage.Literals.MERGE_RULE;
    }

    @Override
    public Rule getMasterRule() {
        if (this.masterRule != null && this.masterRule.eIsProxy()) {
            InternalEObject oldMasterRule = (InternalEObject)this.masterRule;
            this.masterRule = (Rule)this.eResolveProxy(oldMasterRule);
            if (this.masterRule != oldMasterRule && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldMasterRule, (Object)this.masterRule));
            }
        }
        return this.masterRule;
    }

    public Rule basicGetMasterRule() {
        return this.masterRule;
    }

    @Override
    public void setMasterRule(Rule newMasterRule) {
        Rule oldMasterRule = this.masterRule;
        this.masterRule = newMasterRule;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldMasterRule, (Object)this.masterRule));
        }
    }

    @Override
    public EList<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new EObjectResolvingEList(Rule.class, (InternalEObject)this, 1);
        }
        return this.rules;
    }

    @Override
    public EList<MergeRuleElement> getElements() {
        if (this.elements == null) {
            this.elements = new EObjectContainmentEList(MergeRuleElement.class, (InternalEObject)this, 2);
        }
        return this.elements;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (!this.getRules().isEmpty()) {
            Iterator it = this.getRules().iterator();
            while (it.hasNext()) {
                Rule next = (Rule)it.next();
                sb.append(next.getName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<MergeNAC> getMergeNacs() {
        if (this.mergeNacs == null) {
            this.mergeNacs = new EObjectContainmentEList(MergeNAC.class, (InternalEObject)this, 4);
        }
        return this.mergeNacs;
    }

    @Override
    public EList<MergePAC> getMergePacs() {
        if (this.mergePacs == null) {
            this.mergePacs = new EObjectContainmentEList(MergePAC.class, (InternalEObject)this, 5);
        }
        return this.mergePacs;
    }

    @Override
    public MergeRuleElement findMergeRuleElement(GraphElement graphElement) {
        for (MergeRuleElement mergeRuleElement : this.getElements()) {
            if (!mergeRuleElement.getReferenceElements().contains((Object)graphElement)) continue;
            return mergeRuleElement;
        }
        return null;
    }

    @Override
    public void addMergeRuleElement(MergeRuleElement mergeRuleElement) {
        EList<GraphElement> refElemens = mergeRuleElement.getReferenceElements();
        for (MergeRuleElement el : this.getElements()) {
            for (GraphElement ge : el.getReferenceElements()) {
                if (!refElemens.contains((Object)ge)) continue;
                if (el.getReferenceElements().containsAll(refElemens)) {
                    return;
                }
                throw new RuntimeException("Error changing MergeRule: Tried to add a different MergeRuleElement for the same graph element!");
            }
        }
        this.getElements().add((Object)mergeRuleElement);
    }

    @Override
    public void addMergeNAC(MergeNAC mergeNac) {
        EList<Graph> refGraphs = mergeNac.getReferenceNACs();
        for (MergeNAC currentNAC : this.getMergeNacs()) {
            for (Graph g : currentNAC.getReferenceNACs()) {
                if (!refGraphs.contains((Object)g)) continue;
                if (currentNAC.getReferenceNACs().containsAll(refGraphs)) {
                    return;
                }
                throw new RuntimeException("Error changing MergeRule: Tried to add a different MergeNAC for the same graph!");
            }
        }
        this.getMergeNacs().add((Object)mergeNac);
    }

    @Override
    public void addMergePAC(MergePAC mergePac) {
        EList<Graph> refGraphs = mergePac.getReferencePACs();
        for (MergePAC currentPAC : this.getMergePacs()) {
            for (Graph g : currentPAC.getReferencePACs()) {
                if (!refGraphs.contains((Object)g)) continue;
                if (currentPAC.getReferencePACs().containsAll(refGraphs)) {
                    return;
                }
                throw new RuntimeException("Error changing MergeRule: Tried to add a different MergePAC for the same graph!");
            }
        }
        this.getMergePacs().add((Object)mergePac);
    }

    @Override
    public MergeNAC findMergeNAC(Graph graph) {
        for (MergeNAC nac : this.getMergeNacs()) {
            if (!nac.getReferenceNACs().contains((Object)graph)) continue;
            return nac;
        }
        return null;
    }

    @Override
    public MergePAC findMergePAC(Graph graph) {
        for (MergePAC pac : this.getMergePacs()) {
            if (!pac.getReferencePACs().contains((Object)graph)) continue;
            return pac;
        }
        return null;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getElements()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getMergeNacs()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getMergePacs()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getMasterRule();
                }
                return this.basicGetMasterRule();
            }
            case 1: {
                return this.getRules();
            }
            case 2: {
                return this.getElements();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getMergeNacs();
            }
            case 5: {
                return this.getMergePacs();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setMasterRule((Rule)newValue);
                return;
            }
            case 1: {
                this.getRules().clear();
                this.getRules().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getElements().clear();
                this.getElements().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setName((String)newValue);
                return;
            }
            case 4: {
                this.getMergeNacs().clear();
                this.getMergeNacs().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getMergePacs().clear();
                this.getMergePacs().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setMasterRule(null);
                return;
            }
            case 1: {
                this.getRules().clear();
                return;
            }
            case 2: {
                this.getElements().clear();
                return;
            }
            case 3: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.getMergeNacs().clear();
                return;
            }
            case 5: {
                this.getMergePacs().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.masterRule != null;
            }
            case 1: {
                return this.rules != null && !this.rules.isEmpty();
            }
            case 2: {
                return this.elements != null && !this.elements.isEmpty();
            }
            case 3: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 4: {
                return this.mergeNacs != null && !this.mergeNacs.isEmpty();
            }
            case 5: {
                return this.mergePacs != null && !this.mergePacs.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.findMergeRuleElement((GraphElement)arguments.get(0));
            }
            case 1: {
                this.addMergeRuleElement((MergeRuleElement)arguments.get(0));
                return null;
            }
            case 2: {
                this.addMergeNAC((MergeNAC)arguments.get(0));
                return null;
            }
            case 3: {
                this.addMergePAC((MergePAC)arguments.get(0));
                return null;
            }
            case 4: {
                return this.findMergeNAC((Graph)arguments.get(0));
            }
            case 5: {
                return this.findMergePAC((Graph)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MergeRule comprising ");
        sb.append(this.rules.size());
        sb.append(" rules [");
        Iterator it = this.getRules().iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            sb.append(rule.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("] and ");
        sb.append(this.elements.size());
        sb.append(" elements:\n");
        for (MergeRuleElement e : this.elements) {
            sb.append(" * ");
            if (!e.getReferenceElements().isEmpty()) {
                sb.append(((GraphElement)e.getReferenceElements().iterator().next()).toString());
            } else {
                sb.append("null");
            }
            sb.append(" (");
            sb.append(e.getReferenceElements().size());
            sb.append(" corresponding elements)\n");
        }
        return sb.toString();
    }
}

