/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class CloneGroup {
    private List<Rule> rules;
    private Map<Edge, Map<Rule, Edge>> edgeMappings;
    private Map<Attribute, Map<Rule, Attribute>> attributeMappings;
    private Map<Node, Map<Rule, Node>> nodeMappings;

    public CloneGroup() {
        this.rules = new ArrayList<Rule>();
        this.edgeMappings = new LinkedHashMap<Edge, Map<Rule, Edge>>();
        this.attributeMappings = new LinkedHashMap<Attribute, Map<Rule, Attribute>>();
    }

    public CloneGroup(List<Rule> rules, Map<Edge, Map<Rule, Edge>> edgeMappings, Map<Attribute, Map<Rule, Attribute>> attributeMappings) {
        this.rules = rules;
        this.edgeMappings = edgeMappings;
        this.attributeMappings = attributeMappings;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Map<Edge, Map<Rule, Edge>> getEdgeMappings() {
        return this.edgeMappings;
    }

    public Map<Node, Map<Rule, Node>> getNodeMappings() {
        if (this.nodeMappings == null) {
            this.updateNodeMappings();
        }
        return this.nodeMappings;
    }

    public Map<Attribute, Map<Rule, Attribute>> getAttributeMappings() {
        return this.attributeMappings;
    }

    public int getNumberOfCommonEdges() {
        return this.edgeMappings.keySet().size() / this.rules.size();
    }

    public void removeRule(Rule rule) {
        HashSet<Edge> deleteEdges = new HashSet<Edge>();
        HashSet<Attribute> deleteAttributes = new HashSet<Attribute>();
        for (Edge edge : this.edgeMappings.keySet()) {
            Edge correspondingEdge = this.edgeMappings.get(edge).get(rule);
            if (correspondingEdge != null) {
                deleteEdges.add(correspondingEdge);
            }
            this.edgeMappings.get(edge).remove(rule);
        }
        for (Attribute attribute : this.attributeMappings.keySet()) {
            Attribute correspondingAttribute = this.attributeMappings.get(attribute).get(rule);
            if (correspondingAttribute != null) {
                deleteAttributes.add(correspondingAttribute);
            }
            this.attributeMappings.get(attribute).remove(rule);
        }
        for (Edge edge : deleteEdges) {
            this.edgeMappings.remove(edge);
        }
        for (Attribute attribute : deleteAttributes) {
            this.edgeMappings.remove(attribute);
        }
        this.rules.remove(rule);
        this.updateNodeMappings();
    }

    public void removeRules(Collection<Rule> ruleSet) {
        for (Rule r : ruleSet) {
            this.removeRule(r);
        }
    }

    protected void updateNodeMappings() {
        Set<Map<Rule, Node>> innerMaps = this.createInnerMapsForNodeMappings();
        HashMap<Node, Map<Rule, Node>> outerMap = this.createOuterMapsForNodeMappings(innerMaps);
        this.nodeMappings = outerMap;
    }

    private HashMap<Node, Map<Rule, Node>> createOuterMapsForNodeMappings(Set<Map<Rule, Node>> innerMaps) {
        LinkedHashMap<Node, Map<Rule, Node>> outerMap = new LinkedHashMap<Node, Map<Rule, Node>>();
        for (Map<Rule, Node> innerMap : innerMaps) {
            for (Rule rule : innerMap.keySet()) {
                outerMap.put(innerMap.get(rule), innerMap);
            }
        }
        return outerMap;
    }

    private Set<Map<Rule, Node>> createInnerMapsForNodeMappings() {
        Edge innerEdge;
        Map<Rule, Edge> edgeInnerMap;
        HashSet<Map<Rule, Node>> innerMaps = new HashSet<Map<Rule, Node>>();
        for (Edge edge : this.edgeMappings.keySet()) {
            edgeInnerMap = this.edgeMappings.get(edge);
            Map<Rule, Node> innerMapForSource = this.createOrFindInnerMapForNodeMappings(edgeInnerMap.values(), true, innerMaps);
            for (Rule rule : edgeInnerMap.keySet()) {
                innerEdge = edgeInnerMap.get(rule);
                this.addToInnerMapForNodeMappings(innerEdge.getSource(), rule, innerMapForSource);
            }
        }
        for (Edge edge : this.edgeMappings.keySet()) {
            edgeInnerMap = this.edgeMappings.get(edge);
            Map<Rule, Node> innerMapForTarget = this.createOrFindInnerMapForNodeMappings(edgeInnerMap.values(), false, innerMaps);
            for (Rule rule : edgeInnerMap.keySet()) {
                innerEdge = edgeInnerMap.get(rule);
                this.addToInnerMapForNodeMappings(innerEdge.getTarget(), rule, innerMapForTarget);
            }
        }
        return innerMaps;
    }

    private Map<Rule, Node> createOrFindInnerMapForNodeMappings(Collection<Edge> edgeSet, boolean source, Set<Map<Rule, Node>> innerMaps) {
        for (Edge edge : edgeSet) {
            Node nodeToAnalyse = source ? edge.getSource() : edge.getTarget();
            Map<Rule, Node> potentialResult = this.createOrFindInnerMapForNodeMappings(nodeToAnalyse, innerMaps);
            if (potentialResult == null) continue;
            return potentialResult;
        }
        LinkedHashMap<Rule, Node> newInnerMap = new LinkedHashMap<Rule, Node>();
        innerMaps.add(newInnerMap);
        return newInnerMap;
    }

    private Map<Rule, Node> createOrFindInnerMapForNodeMappings(Node node, Set<Map<Rule, Node>> innerMaps) {
        for (Map<Rule, Node> innerMap : innerMaps) {
            for (Rule entry : innerMap.keySet()) {
                if (innerMap.get(entry) != node) continue;
                return innerMap;
            }
        }
        return null;
    }

    private void addToInnerMapForNodeMappings(Node node, Rule hostRule, Map<Rule, Node> innerMap) {
        Node actionNode = node.getActionNode();
        innerMap.put(hostRule, actionNode);
    }

    public int getSize() {
        return this.getEdgeMappings().keySet().size() / this.rules.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" [Size ");
        sb.append(this.getSize());
        sb.append(", ");
        sb.append(this.getRules().size());
        sb.append(" Rules: ");
        Iterator<Rule> it = this.getRules().iterator();
        while (it.hasNext()) {
            Rule r = it.next();
            sb.append(r.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public double getNumberOfCommonLhsEdges() {
        int size = this.edgeMappings.keySet().stream().filter(e -> e.getAction().getType() == Action.Type.DELETE || e.getAction().getType() == Action.Type.PRESERVE).collect(Collectors.toList()).size();
        return size / this.rules.size();
    }
}

