/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clustering;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.clustering.SubCloneRelation;

public class CloneHierarchy {
    Map<CloneGroup, Set<CloneGroup>> superToSubClones = new HashMap<CloneGroup, Set<CloneGroup>>();
    Map<CloneGroup, Set<CloneGroup>> subToSuperClones = new HashMap<CloneGroup, Set<CloneGroup>>();

    public Set<CloneGroup> getSuperClones(CloneGroup cloneGroup) {
        return this.subToSuperClones.get(cloneGroup);
    }

    public Set<CloneGroup> getSubClones(CloneGroup cloneGroup) {
        return this.superToSubClones.get(cloneGroup);
    }

    public void addBasisCloneGroup(CloneGroup cloneGroup) {
        HashSet subClones = new HashSet();
        this.superToSubClones.put(cloneGroup, subClones);
    }

    public void addPair(CloneGroup superCloneGroup, CloneGroup subCloneGroup) {
        if (superCloneGroup == subCloneGroup) {
            System.err.println("Error during the construction of the clone hierarchy: Tried adding a clone group as its own sub clone.");
            return;
        }
        Set<CloneGroup> superClones = this.subToSuperClones.get(subCloneGroup);
        if (superClones == null) {
            superClones = new HashSet<CloneGroup>();
            this.subToSuperClones.put(subCloneGroup, superClones);
        }
        superClones.add(superCloneGroup);
        Set<CloneGroup> subClones = this.superToSubClones.get(superCloneGroup);
        if (subClones == null) {
            subClones = new HashSet<CloneGroup>();
            this.superToSubClones.put(superCloneGroup, subClones);
        }
        subClones.add(subCloneGroup);
    }

    public Set<CloneGroup> getTopCloneGroups() {
        HashSet<CloneGroup> result = new HashSet<CloneGroup>();
        for (CloneGroup cg : this.superToSubClones.keySet()) {
            if (this.subToSuperClones.containsKey(cg) && this.subToSuperClones.get(cg) != null) continue;
            result.add(cg);
        }
        return result;
    }

    public Collection<CloneGroup> getTransitiveSubClones(CloneGroup cloneGroup) {
        HashSet<CloneGroup> result = new HashSet<CloneGroup>();
        if (this.superToSubClones.containsKey(cloneGroup)) {
            for (CloneGroup child : this.superToSubClones.get(cloneGroup)) {
                result.add(child);
                result.addAll(this.getTransitiveSubClones(child));
            }
        }
        if (result.contains(cloneGroup)) {
            throw new RuntimeException("Error in hierarchy");
        }
        return result;
    }

    public void addChild(CloneGroup topCloneGroup, CloneGroup cloneGroup) {
        for (CloneGroup cg : this.getSubClones(topCloneGroup)) {
            if (SubCloneRelation.isSubClone(cg, cloneGroup)) {
                this.addPair(cg, cloneGroup);
                continue;
            }
            if (!SubCloneRelation.isSubClone(cloneGroup, cg)) continue;
            this.addPair(cloneGroup, cg);
        }
        this.addPair(topCloneGroup, cloneGroup);
    }
}

