/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clustering;

import com.apporiented.algorithm.clustering.AverageLinkageStrategy;
import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.DefaultClusteringAlgorithm;
import com.apporiented.algorithm.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.clustering.RuleClusterer;

public class DefaultAgglomerativeRuleClusterer
implements RuleClusterer {
    List<CloneGroup> cloneGroups;
    Map<Rule, Map<Rule, CloneGroup>> largestClones;
    double largestCloneTotalSize;
    double largestRuleSize;
    Map<String, Rule> nameToRule;
    Map<Rule, Integer> ruleToSize;
    List<Rule> rules;
    double distanceThreshold;
    boolean includeRhs;
    static final double DISTANCT_THRESHOLD_DEFAULT = 0.55;
    static final boolean INCLUDE_RHS_DEFAULT = true;

    @Override
    public List<List<Rule>> clusterRules(List<CloneGroup> theCloneGroups) {
        return this.clusterRules(theCloneGroups, 0.55, true);
    }

    public List<List<Rule>> clusterRules(List<CloneGroup> theCloneGroups, boolean includeRhs) {
        this.includeRhs = includeRhs;
        return this.clusterRules(theCloneGroups, 0.55, includeRhs);
    }

    @Override
    public List<List<Rule>> clusterRules(List<CloneGroup> theCloneGroups, double distanceThreshold, boolean includeRhs) {
        this.distanceThreshold = distanceThreshold;
        this.includeRhs = includeRhs;
        this.cloneGroups = theCloneGroups;
        this.initialize();
        ArrayList<List<Rule>> result = new ArrayList<List<Rule>>();
        if (this.rules.isEmpty()) {
            return result;
        }
        String[] names = this.getRuleNames(this.rules).toArray(new String[this.rules.size()]);
        double[][] distances = this.getDistances();
        DefaultClusteringAlgorithm alg = new DefaultClusteringAlgorithm();
        Cluster cluster = alg.performClustering(distances, names, (LinkageStrategy)new AverageLinkageStrategy());
        this.addToResult(cluster, result);
        this.sortRules();
        System.out.println("[Info] Determined" + result.size() + " clusters");
        return result;
    }

    private void printDistances(String[] names, double[][] distances) {
        int i = 0;
        while (i < names.length) {
            System.out.print(String.valueOf(i) + " = " + names[i]);
            if (i + 1 < names.length) {
                System.out.print(", ");
            }
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < distances.length) {
            int j = 0;
            while (j < distances[i].length) {
                System.out.print(String.valueOf((double)Math.round(distances[i][j] * 100.0) / 100.0) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private List<List<Rule>> addToResult(Cluster cluster, List<List<Rule>> result) {
        if (cluster.getChildren().isEmpty()) {
            List<Rule> list = Collections.singletonList(this.nameToRule.get(cluster.getName()));
            result.add(list);
        } else if (cluster.getDistance().getDistance() < this.distanceThreshold) {
            ArrayList<Rule> resultCluster = new ArrayList<Rule>();
            result.add(resultCluster);
            this.addChildrenToOneResultCluster(cluster.getChildren(), resultCluster);
        } else {
            for (Cluster child : cluster.getChildren()) {
                this.addToResult(child, result);
            }
        }
        return result;
    }

    private void addChildrenToOneResultCluster(List<Cluster> children, List<Rule> resultCluster) {
        for (Cluster child : children) {
            if (child.getChildren().isEmpty()) {
                resultCluster.add(this.nameToRule.get(child.getName()));
                continue;
            }
            this.addChildrenToOneResultCluster(child.getChildren(), resultCluster);
        }
    }

    private double[][] getDistances() {
        int j;
        double[][] result = new double[this.rules.size()][this.rules.size()];
        int i = 0;
        while (i < this.rules.size()) {
            j = i + 1;
            while (j < this.rules.size()) {
                result[i][j] = this.getDistance(this.rules.get(i), this.rules.get(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.rules.size()) {
            j = 0;
            while (j < i) {
                result[i][j] = result[j][i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.rules.size()) {
            result[i][i] = 0.0;
            ++i;
        }
        return result;
    }

    private double getDistance(Rule rule, Rule rule2) {
        return 1.0 / (this.calculcateSimilarity(rule, rule2) + 1.0);
    }

    private List<String> getRuleNames(List<Rule> rules) {
        ArrayList<String> result = new ArrayList<String>();
        for (Rule rule : rules) {
            result.add(rule.getName());
        }
        return result;
    }

    public double calculcateSimilarity(Rule rule, Rule rule2) {
        double clonesize = 0.0;
        if (this.largestClones.containsKey(rule) && this.largestClones.get(rule).containsKey(rule2)) {
            clonesize = this.largestClones.get(rule).get(rule2).getSize();
        }
        double rulesize = (double)(this.ruleToSize.get(rule) + this.ruleToSize.get(rule2)) / 2.0;
        return clonesize / rulesize;
    }

    private void initialize() {
        this.largestClones = new HashMap<Rule, Map<Rule, CloneGroup>>();
        for (CloneGroup cg : this.cloneGroups) {
            this.initializeInnerMaps(this.largestClones, cg);
            for (Rule r1 : cg.getRules()) {
                for (Rule r2 : cg.getRules()) {
                    CloneGroup existingEntry = this.largestClones.get(r1).get(r2);
                    if (existingEntry != null && cg.getSize() <= existingEntry.getSize()) continue;
                    this.largestClones.get(r1).put(r2, cg);
                    this.largestClones.get(r2).put(r1, cg);
                }
            }
            if (!(this.largestCloneTotalSize < (double)cg.getSize())) continue;
            this.largestCloneTotalSize = cg.getSize();
        }
        this.rules = new ArrayList<Rule>();
        this.rules.addAll(this.largestClones.keySet());
        this.nameToRule = new HashMap<String, Rule>();
        this.ruleToSize = new HashMap<Rule, Integer>();
        for (Rule rule : this.rules) {
            this.nameToRule.put(rule.getName(), rule);
            this.ruleToSize.put(rule, this.getSize(rule));
        }
        this.setLargestRule();
        this.sortRules();
    }

    private void setLargestRule() {
        this.largestRuleSize = 0.0;
        for (Rule rule : this.rules) {
            int currentRuleSize = this.ruleToSize.get(rule);
            if (!(this.largestRuleSize < (double)currentRuleSize)) continue;
            this.largestRuleSize = currentRuleSize;
        }
    }

    private int getSize(Rule rule) {
        int size = 0;
        if (rule == null) {
            return size;
        }
        size = rule.getActionEdges(new Action(Action.Type.DELETE)).size() + rule.getActionEdges(new Action(Action.Type.PRESERVE)).size() + (this.includeRhs ? rule.getActionEdges(new Action(Action.Type.CREATE)).size() : 0);
        return size;
    }

    private void initializeInnerMaps(Map<Rule, Map<Rule, CloneGroup>> outerMap, CloneGroup cg) {
        for (Rule r1 : cg.getRules()) {
            Map<Rule, CloneGroup> innerMap = this.largestClones.get(r1);
            if (innerMap != null) continue;
            innerMap = new HashMap<Rule, CloneGroup>();
            outerMap.put(r1, innerMap);
        }
    }

    public void sortRules() {
        Collections.sort(this.rules, new Comparator<Rule>(){

            @Override
            public int compare(Rule arg0, Rule arg1) {
                return DefaultAgglomerativeRuleClusterer.this.ruleToSize.get(arg0) - DefaultAgglomerativeRuleClusterer.this.ruleToSize.get(arg1);
            }
        });
    }

    public void printRuleInfo() {
        for (Rule rule : this.rules) {
            System.out.println(" * " + rule.getName() + ": " + this.ruleToSize.get(rule));
        }
    }
}

