/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.conqat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.IConQATLogger;
import org.conqat.engine.model_clones.detection.ModelCloneReporterMock;
import org.conqat.engine.model_clones.detection.clustering.CloneClusterer;
import org.conqat.engine.model_clones.detection.pairs.PairDetector;
import org.conqat.engine.model_clones.detection.util.AugmentedModelGraph;
import org.conqat.engine.model_clones.detection.util.ICloneReporter;
import org.conqat.engine.model_clones.model.IDirectedEdge;
import org.conqat.engine.model_clones.model.IModelGraph;
import org.eclipse.emf.henshin.variability.mergein.conqat.HenshinToConqatGraphConverter;
import org.eclipse.emf.henshin.variability.mergein.conqat.HenshinToConqatGraphElementMap;
import org.eclipse.emf.henshin.variability.mergein.normalize.AttributeEReference;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;

public class ConqatManager {
    private List<HenshinGraph> ruleGraphs;
    private IModelGraph modelGraph;
    private HenshinToConqatGraphElementMap henshin2ConqatGraphElementMap = new HenshinToConqatGraphElementMap();
    private ModelCloneReporterMock resultReporter;
    private int minSize;

    public ConqatManager(List<HenshinGraph> ruleGraphs, int minSize) {
        this.ruleGraphs = ruleGraphs;
        this.minSize = minSize;
    }

    public void doCloneDetection() {
        this.modelGraph = this.createModelGraph();
        try {
            this.resultReporter = this.runDetection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IModelGraph createModelGraph() {
        return new HenshinToConqatGraphConverter(this.ruleGraphs, this.henshin2ConqatGraphElementMap).createConqatGraph();
    }

    protected ModelCloneReporterMock runDetection() throws Exception {
        AugmentedModelGraph mag = new AugmentedModelGraph(this.modelGraph);
        ModelCloneReporterMock result = new ModelCloneReporterMock();
        IConQATLogger logger = this.createDummyLogger();
        CloneClusterer clusterer = new CloneClusterer(mag, (ICloneReporter)result, logger, false);
        new PairDetector(mag, this.minSize, 1, true, (ICloneReporter)clusterer, logger).execute();
        clusterer.performInclusionAnalysis();
        clusterer.performClustering();
        return result;
    }

    public ModelCloneReporterMock getResultReporter() {
        return this.resultReporter;
    }

    public List<HenshinGraph> getInvolvedHenshinGraphs(ModelCloneReporterMock.ModelClone clone) {
        ArrayList<HenshinGraph> result = new ArrayList<HenshinGraph>();
        for (List edgeList : clone.edges) {
            for (IDirectedEdge edge : edgeList) {
                result.add(this.henshin2ConqatGraphElementMap.get(edge).getHenshinGraph());
            }
        }
        return result;
    }

    public Map<HenshinEdge, Map<HenshinGraph, HenshinEdge>> createHenshinEdgeMappings(ModelCloneReporterMock.ModelClone clone) {
        LinkedHashMap<HenshinEdge, Map<HenshinGraph, HenshinEdge>> outerMap = new LinkedHashMap<HenshinEdge, Map<HenshinGraph, HenshinEdge>>();
        ArrayList innerMaps = new ArrayList();
        List arbitraryCloneInstance = (List)clone.edges.iterator().next();
        int numberOfEdgesInClone = arbitraryCloneInstance.size();
        int i = 0;
        while (i < numberOfEdgesInClone) {
            innerMaps.add(new HashMap());
            ++i;
        }
        for (List cloneInstance : clone.edges) {
            int i2 = 0;
            while (i2 < cloneInstance.size()) {
                Map innerMap = (Map)innerMaps.get(i2);
                IDirectedEdge edge = (IDirectedEdge)cloneInstance.get(i2);
                HenshinEdge newEdge = this.henshin2ConqatGraphElementMap.get(edge);
                HenshinGraph newGraph = newEdge.getHenshinGraph();
                innerMap.put(newGraph, newEdge);
                outerMap.put(newEdge, innerMap);
                ++i2;
            }
        }
        return outerMap;
    }

    public Map<HenshinEdge, Map<HenshinGraph, HenshinEdge>> createHenshinAttributeMappings(ModelCloneReporterMock.ModelClone clone) {
        LinkedHashMap<HenshinEdge, Map<HenshinGraph, HenshinEdge>> outerMap = new LinkedHashMap<HenshinEdge, Map<HenshinGraph, HenshinEdge>>();
        ArrayList innerMaps = new ArrayList();
        List arbitraryCloneInstance = (List)clone.edges.iterator().next();
        int numberOfEdgesInClone = arbitraryCloneInstance.size();
        int i = 0;
        while (i < numberOfEdgesInClone) {
            innerMaps.add(new HashMap());
            ++i;
        }
        for (List edgesOfOneGraph : clone.edges) {
            int i2 = 0;
            while (i2 < edgesOfOneGraph.size()) {
                Map innerMap = (Map)innerMaps.get(i2);
                IDirectedEdge edge = (IDirectedEdge)edgesOfOneGraph.get(i2);
                HenshinEdge newEdge = this.henshin2ConqatGraphElementMap.get(edge);
                if (newEdge.getType() == AttributeEReference.instance) {
                    HenshinGraph newGraph = newEdge.getHenshinGraph();
                    innerMap.put(newGraph, newEdge);
                    outerMap.put(newEdge, innerMap);
                }
                ++i2;
            }
        }
        return outerMap;
    }

    private IConQATLogger createDummyLogger() {
        return new IConQATLogger(){

            public void debug(Object arg0) {
            }

            public void debug(Object arg0, Throwable arg1) {
            }

            public void error(Object arg0) {
            }

            public void error(Object arg0, Throwable arg1) {
            }

            public void info(Object arg0) {
            }

            public void info(Object arg0, Throwable arg1) {
            }

            public void warn(Object arg0) {
            }

            public void warn(Object arg0, Throwable arg1) {
            }

            public ELogLevel getMinLogLevel() {
                return null;
            }

            public void log(ELogLevel arg0, Object arg1) {
            }

            public void log(ELogLevel arg0, Object arg1, Throwable arg2) {
            }
        };
    }
}

