/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.normalize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.variability.mergein.normalize.AttributeEReference;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinAttributeNode;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinEdge;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinNode;
import org.jgrapht.graph.Multigraph;

public class HenshinGraph
extends Multigraph<HenshinNode, HenshinEdge> {
    private static final long serialVersionUID = 1L;
    Map<Edge, HenshinEdge> edge2representation = new HashMap<Edge, HenshinEdge>();
    Map<Node, HenshinNode> node2representation = new HashMap<Node, HenshinNode>();
    Map<Attribute, HenshinEdge> attribute2representation = new HashMap<Attribute, HenshinEdge>();
    Map<HenshinEdge, Edge> representation2edge = new HashMap<HenshinEdge, Edge>();
    Map<HenshinNode, Node> representation2node = new HashMap<HenshinNode, Node>();
    Map<HenshinEdge, Attribute> representation2attribute = new HashMap<HenshinEdge, Attribute>();
    private String ruleName;

    public HenshinGraph() {
        super(HenshinEdge.class);
    }

    public boolean containsEdge(Edge edge) {
        return this.edge2representation.containsKey(edge);
    }

    public boolean containsAttribute(Attribute attribute) {
        return this.edge2representation.containsKey(attribute);
    }

    public boolean containsNode(Node node) {
        return this.node2representation.containsKey(node);
    }

    public HenshinNode getRepresentation(Node node) {
        return this.node2representation.get(node);
    }

    public HenshinEdge getRepresentation(Edge edge) {
        return this.edge2representation.get(edge);
    }

    public HenshinEdge getRepresentation(Attribute attribute) {
        return this.edge2representation.get(attribute);
    }

    public Node getRepresentedNode(HenshinNode node) {
        return this.representation2node.get(node);
    }

    public Edge getRepresentedEdge(HenshinEdge edge) {
        return this.representation2edge.get(edge);
    }

    public Attribute getRepresentedAttribute(HenshinEdge edge) {
        return this.representation2attribute.get(edge);
    }

    public void addVertex(Node node) {
        throw new UnsupportedOperationException("Use addVertex(node, graphNode) instead.");
    }

    public void addVertex(Node node, HenshinNode graphNode) {
        this.node2representation.put(node, graphNode);
        this.representation2node.put(graphNode, node);
        super.addVertex((Object)graphNode);
    }

    public boolean addEdge(Node source, Node target, Edge e, HenshinEdge edge) {
        HenshinNode sourceNode = this.node2representation.get(source);
        HenshinNode targetNode = this.node2representation.get(target);
        if (sourceNode != null && targetNode != null) {
            this.addEdge(sourceNode, targetNode, edge);
            this.edge2representation.put(e, edge);
            this.representation2edge.put(edge, e);
            return true;
        }
        return false;
    }

    public boolean addAttribute(Attribute attribute, Action.Type actionType, String ruleName) {
        Node containerNode = attribute.getNode().getActionNode();
        HenshinNode sourceNode = this.node2representation.get(containerNode);
        if (sourceNode != null) {
            HenshinAttributeNode attributeNode = new HenshinAttributeNode(this, (EObject)attribute.getType(), actionType, ruleName, attribute.getValue());
            super.addVertex((Object)attributeNode);
            HenshinEdge integratedEdge = new HenshinEdge(this, (EReference)AttributeEReference.instance, actionType, ruleName, true);
            this.addEdge(sourceNode, attributeNode, integratedEdge);
            this.attribute2representation.put(attribute, integratedEdge);
            this.representation2attribute.put(integratedEdge, attribute);
            return true;
        }
        throw new RuntimeException("Error during Henshin graph creation");
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String toStringRepresentation() {
        StringBuilder result = new StringBuilder();
        result.append("Graph " + this.ruleName + ": " + this.vertexSet().size() + " nodes, " + this.edgeSet().size() + " edges\n");
        for (HenshinNode v : this.vertexSet()) {
            result.append(" * " + ((ENamedElement)v.getType()).getName() + " " + v.getActionType().name() + " (incoming: " + this.incomingEdgesOf(v).size() + ", outgoing: " + this.outgoingEdgesOf(v).size() + ")\n");
        }
        return result.toString();
    }
}

