/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.configuration.ui.parts;

import configuration.Feature;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.ImageHelper;
import org.eclipse.emf.henshin.variability.configuration.ui.parts.ITableViewerSynchronizedPart;
import org.eclipse.emf.henshin.variability.configuration.ui.parts.SynchronizedTableViewer;
import org.eclipse.emf.henshin.variability.ui.viewer.util.FeatureViewerBindingEditingSupport;
import org.eclipse.emf.henshin.variability.ui.viewer.util.FeatureViewerComparator;
import org.eclipse.emf.henshin.variability.ui.viewer.util.FeatureViewerContentProvider;
import org.eclipse.emf.henshin.variability.ui.viewer.util.FeatureViewerNameEditingSupport;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ConfigurationTableViewer
extends SynchronizedTableViewer {
    private FeatureViewerComparator comparator;

    public ConfigurationTableViewer(Composite parent, int style, TableColumnLayout tableColumnLayout, ITableViewerSynchronizedPart synchronizedPart) {
        super(parent, style, synchronizedPart);
        this.createColumns(parent, tableColumnLayout);
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        this.setContentProvider((IContentProvider)new FeatureViewerContentProvider());
        this.comparator = new FeatureViewerComparator();
        this.setComparator(this.comparator);
    }

    private void createColumns(Composite parent, TableColumnLayout tableColumnLayout) {
        String[] titles = new String[]{"Feature", "Binding"};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Feature vp = (Feature)element;
                return vp.getName();
            }

            public Image getImage(Object element) {
                return ImageHelper.getImage("/icons/table_default.png");
            }
        });
        col.setEditingSupport((EditingSupport)new FeatureViewerNameEditingSupport(this));
        tableColumnLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(60, false));
        col = this.createTableViewerColumn(titles[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Feature vp = (Feature)element;
                return vp.getBinding().getName();
            }

            public Image getImage(Object element) {
                return ImageHelper.getImage("/icons/table_default.png");
            }
        });
        col.setEditingSupport((EditingSupport)new FeatureViewerBindingEditingSupport(this));
        tableColumnLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, false));
    }

    private TableViewerColumn createTableViewerColumn(String title, int index) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this, 0, index);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(false);
        column.setMoveable(false);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, index));
        return viewerColumn;
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationTableViewer.this.comparator.setColumn(index);
                int sortDirection = ConfigurationTableViewer.this.comparator.getDirection();
                ConfigurationTableViewer.this.getTable().setSortDirection(sortDirection);
                ConfigurationTableViewer.this.getTable().setSortColumn(column);
                ConfigurationTableViewer.this.refresh();
            }
        };
        return selectionAdapter;
    }
}

