/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.security.SecureRandom;
import org.eclipse.net4j.core.Randomizer;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public class RandomizerImpl
extends ServiceImpl
implements Randomizer {
    public static final String DEFAULT_ALGORITHM_NAME = "SHA1PRNG";
    private String algorithmName = "SHA1PRNG";
    private String packageName;
    private transient SecureRandom secureRandom;

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.doSet("algorithmName", algorithmName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.doSet("packageName", packageName);
    }

    public boolean nextBoolean() {
        return this.secureRandom.nextBoolean();
    }

    public double nextDouble() {
        return this.secureRandom.nextDouble();
    }

    public float nextFloat() {
        return this.secureRandom.nextFloat();
    }

    public synchronized double nextGaussian() {
        return this.secureRandom.nextGaussian();
    }

    public int nextInt() {
        return this.secureRandom.nextInt();
    }

    public int nextInt(int n) {
        return this.secureRandom.nextInt(n);
    }

    public long nextLong() {
        return this.secureRandom.nextLong();
    }

    public byte[] generateSeed(int numBytes) {
        return this.secureRandom.generateSeed(numBytes);
    }

    public String getAlgorithm() {
        return this.secureRandom.getAlgorithm();
    }

    public synchronized void nextBytes(byte[] bytes) {
        this.secureRandom.nextBytes(bytes);
    }

    public synchronized void setSeed(byte[] seed) {
        this.secureRandom.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.secureRandom.setSeed(seed);
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("algorithmName");
        try {
            this.secureRandom = this.packageName == null ? SecureRandom.getInstance(this.algorithmName) : SecureRandom.getInstance(this.algorithmName, this.packageName);
        }
        catch (Exception ex) {
            throw new ValidationException("Secure random generator could not be initialized", (Throwable)ex);
        }
        this.secureRandom.setSeed(System.currentTimeMillis());
    }

    protected void deactivate() throws Exception {
        this.algorithmName = null;
        this.packageName = null;
        this.secureRandom = null;
        super.deactivate();
    }
}

