/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.gmf.runtime.diagram.ui.internal.dialogs.PageSetupControlType;
import org.eclipse.gmf.runtime.diagram.ui.internal.dialogs.PageSetupDialog;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.ILabels;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageSetupWidgetFactory;
import org.eclipse.gmf.runtime.diagram.ui.preferences.PrintingPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PageSetupSelectionConfigBlock
implements ILabels {
    private Button fButtonUseWorkspaceSettings;
    private Button fButtonConfigure;
    private Button fButtonUseDiagramSettings;
    private Shell fShell;
    private Initializer fInitialier;
    private Persistor fPersistor;
    private ArrayList fControls = new ArrayList();
    private IPreferenceStore fStore;
    private IPreferenceStore fGlobalStore;
    private PageSetupDialog fParentDialog;

    public PageSetupSelectionConfigBlock(IPreferenceStore store, IPreferenceStore globalStore, PageSetupDialog dialog) {
        this.fInitialier = new Initializer(this);
        this.fPersistor = new Persistor(this);
        this.fStore = store;
        this.fGlobalStore = globalStore;
        this.fParentDialog = dialog;
    }

    protected Control createContents(Composite parent) {
        Composite selectionComposite = new Composite(parent, 0);
        selectionComposite.setLayout((Layout)new GridLayout(2, true));
        this.createSelectionGroup(selectionComposite);
        this.fShell = parent.getShell();
        this.fInitialier.initSelectionControls();
        return selectionComposite;
    }

    protected void save() {
        this.fPersistor.saveConfigBlockControlValues();
    }

    private void createSelectionGroup(Composite composite) {
        this.fButtonUseWorkspaceSettings = PageSetupWidgetFactory.createRadioButton(composite, LABEL_BUTTON_USE_WORKSPACE_SETTINGS);
        this.fButtonConfigure = PageSetupWidgetFactory.createPushButton(composite, LABEL_BUTTON_CONFIGURE_WORKSPACE_SETTINGS);
        this.fButtonUseDiagramSettings = PageSetupWidgetFactory.createRadioButton(composite, LABEL_BUTTON_USE_DIAGRAM_SETTINGS);
        if (this.fGlobalStore == null || !(this.fGlobalStore instanceof IPersistentPreferenceStore)) {
            this.fButtonUseWorkspaceSettings.setEnabled(false);
        }
        this.addUseWorkspaceSettingsListener();
        this.addUseDiagramSettingsListener();
        this.addConfigureWorkspaceSettingsListener();
        this.fControls.add(this.fButtonUseWorkspaceSettings);
        this.fControls.add(this.fButtonConfigure);
        this.fControls.add(this.fButtonUseDiagramSettings);
    }

    private void addUseWorkspaceSettingsListener() {
        this.fButtonUseWorkspaceSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PageSetupSelectionConfigBlock.this.fParentDialog.getConfigurationBlock().disableAllControls();
                PageSetupSelectionConfigBlock.this.fButtonConfigure.setEnabled(true);
                PageSetupSelectionConfigBlock.this.fParentDialog.getOkButton().setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addUseDiagramSettingsListener() {
        this.fButtonUseDiagramSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PageSetupSelectionConfigBlock.this.fParentDialog.getConfigurationBlock().enableAllControls();
                PageSetupSelectionConfigBlock.this.fButtonConfigure.setEnabled(false);
                PageSetupSelectionConfigBlock.this.fParentDialog.getConfigurationBlock().setOkButtonEnableStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addConfigureWorkspaceSettingsListener() {
        this.fButtonConfigure.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PrintingPreferencePage page = new PrintingPreferencePage(PageSetupSelectionConfigBlock.this.fGlobalStore);
                page.setTitle(ILabels.LABEL_PREFERENCE_PAGE_PRINTING);
                PreferenceNode targetNode = new PreferenceNode("id.pageSetupPreferencePage", (IPreferencePage)page);
                PreferenceManager manager = new PreferenceManager();
                manager.addToRoot((IPreferenceNode)targetNode);
                PreferenceDialog dialog = new PreferenceDialog(PageSetupSelectionConfigBlock.this.fShell, manager);
                dialog.create();
                dialog.setMessage(TITLE_PAGE_SETUP_TAB_ITEM);
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public Control getControl(PageSetupControlType controlType) {
        if (controlType.equals(PageSetupControlType.BUTTON_USE_WORKSPACE_SETTINGS)) {
            return this.fButtonUseWorkspaceSettings;
        }
        if (controlType.equals(PageSetupControlType.BUTTON_USE_DIAGRAM_SETTINGS)) {
            return this.fButtonUseDiagramSettings;
        }
        if (controlType.equals(PageSetupControlType.BUTTON_CONFIGURE_WORKSPACE_SETTINGS)) {
            return this.fButtonConfigure;
        }
        return null;
    }

    public void disableButtonConfigure() {
        this.fButtonConfigure.setEnabled(false);
    }

    public void enableButtonConfigure() {
        this.fButtonConfigure.setEnabled(true);
    }

    private class Initializer {
        private PageSetupSelectionConfigBlock fBlockPrint;

        public Initializer(PageSetupSelectionConfigBlock configBlock) {
            this.fBlockPrint = configBlock;
        }

        public void initSelectionControls() {
            this.initRadioButtons();
        }

        private void initRadioButtons() {
            this.initRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_WORKSPACE_SETTINGS, "print.useWorkspaceSettings");
            this.initRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_DIAGRAM_SETTINGS, "print.useDiagramSettings");
        }

        private void initRadioButton(PageSetupSelectionConfigBlock block, PageSetupControlType controlType, String key) {
            Button button = (Button)block.getControl(controlType);
            button.setSelection(PageSetupSelectionConfigBlock.this.fStore.getBoolean(key));
        }
    }

    private class Persistor {
        private PageSetupSelectionConfigBlock fBlockPrint;

        public Persistor(PageSetupSelectionConfigBlock configBlock) {
            this.fBlockPrint = configBlock;
        }

        public void saveConfigBlockControlValues() {
            this.saveConfigRadioButtonValues();
        }

        private void saveConfigRadioButtonValues() {
            this.saveRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_WORKSPACE_SETTINGS, "print.useWorkspaceSettings");
            this.saveRadioButton(this.fBlockPrint, PageSetupControlType.BUTTON_USE_DIAGRAM_SETTINGS, "print.useDiagramSettings");
        }

        private void saveRadioButton(PageSetupSelectionConfigBlock block, PageSetupControlType controlType, String key) {
            Button button = (Button)block.getControl(controlType);
            PageSetupSelectionConfigBlock.this.fStore.setValue(key, button.getSelection());
        }
    }
}

