/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.ColorBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.DialogBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.JobAttributesBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.QualityBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.SidesBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class JPSOptionsDialog
extends TrayDialog {
    private DataBindingContext bindings;
    public final PrintOptions options;
    private QualityBlock qualityBlock;
    private ColorBlock colorBlock;
    private SidesBlock sidesBlock;
    private JobAttributesBlock jobAttributesBlock;
    private final DialogBlock.IDialogUnitConverter dluConverter = new DialogBlock.IDialogUnitConverter(){

        public int convertHorizontalDLUsToPixels(int dlus) {
            return JPSOptionsDialog.this.convertHorizontalDLUsToPixels(dlus);
        }

        public Shell getShell() {
            return JPSOptionsDialog.this.getShell();
        }
    };

    protected JPSOptionsDialog(Shell shell, DataBindingContext bindings, PrintOptions options) {
        super(shell);
        this.options = options;
        this.bindings = bindings;
    }

    public JPSOptionsDialog(IShellProvider parentShell, DataBindingContext bindings, PrintOptions options) {
        super(parentShell);
        this.options = options;
        this.bindings = bindings;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DiagramUIPrintingMessages.JPSOptionsDialog_AdvancedOptions);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = new Composite(parent, 0);
        DialogBlock.layout(result, 2);
        this.createColorBlockArea(result);
        this.createQualityBlockArea(result);
        this.createSidesBlockArea(result);
        this.createJobAttributesBlockArea(result);
        return result;
    }

    protected void createQualityBlockArea(Composite result) {
        this.qualityBlock = new QualityBlock(this.dluConverter, this.bindings, this.options);
        this.qualityBlock.createContents(result);
    }

    protected void createColorBlockArea(Composite result) {
        this.colorBlock = new ColorBlock(this.dluConverter, this.bindings, this.options);
        this.colorBlock.createContents(result);
    }

    protected void createSidesBlockArea(Composite result) {
        this.sidesBlock = new SidesBlock(this.dluConverter, this.bindings, this.options);
        this.sidesBlock.createContents(result);
    }

    protected void createJobAttributesBlockArea(Composite result) {
        this.jobAttributesBlock = new JobAttributesBlock(this.dluConverter, this.bindings, this.options);
        this.jobAttributesBlock.createContents(result);
    }

    public boolean close() {
        this.qualityBlock.dispose();
        this.colorBlock.dispose();
        this.sidesBlock.dispose();
        this.jobAttributesBlock.dispose();
        return super.close();
    }
}

