/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jet.core.compiler.JETCompilerOptions;
import org.osgi.service.prefs.Preferences;

public class CompileOptionsManager {
    private static CompileOptionsManager manager = null;
    private final IEclipsePreferences configurationNode;
    private final IEclipsePreferences instanceNode;
    private final IEclipsePreferences defaultsNode = new DefaultScope().getNode("org.eclipse.jet");

    public static CompileOptionsManager getInstance() {
        if (manager == null) {
            manager = new CompileOptionsManager();
        }
        return manager;
    }

    private CompileOptionsManager() {
        this.configurationNode = new ConfigurationScope().getNode("org.eclipse.jet");
        this.instanceNode = new InstanceScope().getNode("org.eclipse.jet");
    }

    public Map getOptionsForProject(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.jet");
        IEclipsePreferences[] searchList = new IEclipsePreferences[]{projectNode, this.instanceNode, this.configurationNode, this.defaultsNode};
        IPreferencesService service = Platform.getPreferencesService();
        Set keys = JETCompilerOptions.getDefaultCompilerOptions().keySet();
        HashMap<String, String> result = new HashMap<String, String>(keys.size());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = service.get(key, null, (Preferences[])searchList);
            result.put(key, value);
        }
        return result;
    }

    public static Map getOptions(IProject project) {
        return CompileOptionsManager.getInstance().getOptionsForProject(project);
    }
}

