/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUtil {
    private static final String NL_PATTERN = "([\\n][\\r]?|[\\r][\\n]?)";

    private JavaUtil() {
    }

    public static String escapeJavaString(char[] text) {
        StringBuffer buffer = new StringBuffer(text.length);
        JavaUtil.escapeJavaString(text, buffer);
        return buffer.toString();
    }

    public static void escapeJavaString(char[] originalText, StringBuffer escapedText) {
        int i = 0;
        while (i < originalText.length) {
            switch (originalText[i]) {
                case '\b': {
                    escapedText.append("\\b");
                    break;
                }
                case '\f': {
                    escapedText.append("\\f");
                    break;
                }
                case '\t': {
                    escapedText.append("\\t");
                    break;
                }
                case '\r': {
                    escapedText.append("\\r");
                    break;
                }
                case '\n': {
                    escapedText.append("\\n");
                    break;
                }
                case '\"': {
                    escapedText.append("\\\"");
                    break;
                }
                case '\\': {
                    escapedText.append("\\\\");
                    break;
                }
                default: {
                    escapedText.append(originalText[i]);
                }
            }
            ++i;
        }
    }

    public static String asJavaQuotedString(char[] text) {
        StringBuffer encoded = new StringBuffer(text.length + 2);
        encoded.append('\"');
        JavaUtil.escapeJavaString(text, encoded);
        encoded.append('\"');
        return encoded.toString();
    }

    public static String asJavaQuotedString(String content) {
        return JavaUtil.asJavaQuotedString(content.toCharArray());
    }

    public static String asJavaQuoteStringWithNLRemoved(char[] text) {
        String rawString = new String(text);
        Matcher m = Pattern.compile(NL_PATTERN, 8).matcher(rawString);
        int nextStringStart = 0;
        boolean nlFound = m.find();
        if (nlFound) {
            StringBuffer result = new StringBuffer(text.length);
            boolean firstExprComponent = true;
            while (nlFound) {
                if (firstExprComponent) {
                    firstExprComponent = false;
                } else {
                    result.append(" + ");
                }
                if (m.start() > nextStringStart) {
                    result.append(JavaUtil.asJavaQuotedString(rawString.substring(nextStringStart, m.start()).toCharArray()));
                    result.append(" + ");
                }
                result.append("NL");
                nextStringStart = m.end();
                nlFound = m.find();
            }
            if (nextStringStart < rawString.length() && !firstExprComponent) {
                result.append(" + ");
                result.append(JavaUtil.asJavaQuotedString(rawString.substring(nextStringStart).toCharArray()));
            }
            return result.toString();
        }
        return JavaUtil.asJavaQuotedString(text);
    }

    public static String[] asJavaQuotedStrings(char[] text, String nlConstantName) {
        String rawString = new String(text);
        Matcher m = Pattern.compile(NL_PATTERN, 8).matcher(rawString);
        int nextStringStart = 0;
        boolean nlFound = m.find();
        if (nlFound) {
            ArrayList<String> constants = new ArrayList<String>();
            while (nlFound) {
                if (m.start() > nextStringStart) {
                    constants.add(JavaUtil.asJavaQuotedString(rawString.substring(nextStringStart, m.start()).toCharArray()));
                }
                constants.add(nlConstantName != null ? nlConstantName : JavaUtil.asJavaQuotedString(m.group().toCharArray()));
                nextStringStart = m.end();
                nlFound = m.find();
            }
            if (nextStringStart < rawString.length()) {
                constants.add(JavaUtil.asJavaQuotedString(rawString.substring(nextStringStart).toCharArray()));
            }
            return constants.toArray(new String[constants.size()]);
        }
        return new String[]{JavaUtil.asJavaQuotedString(text)};
    }

    public static String nlsCommentsForJavaQuoteStringWithNLRemoved(char[] text) {
        String rawString = new String(text);
        Matcher nlMatch = Pattern.compile(NL_PATTERN, 8).matcher(rawString);
        int nextLiteralStart = 0;
        int i = 0;
        StringBuffer result = new StringBuffer(text.length);
        boolean nlFound = nlMatch.find();
        while (nlFound) {
            if (nlMatch.start() > nextLiteralStart) {
                JavaUtil.nlComment(result, ++i);
            }
            nextLiteralStart = nlMatch.end();
            nlFound = nlMatch.find();
        }
        if (nextLiteralStart < rawString.length() || rawString.length() == 0) {
            JavaUtil.nlComment(result, ++i);
        }
        return result.toString();
    }

    private static StringBuffer nlComment(StringBuffer result, int i) {
        return result.append(" //$NON-NLS-").append(i).append("$");
    }
}

