/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler.templates;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.compiler.DefaultJET2ASTVisitor;
import org.eclipse.jet.compiler.JET2CompilationUnit;
import org.eclipse.jet.compiler.JET2Declaration;
import org.eclipse.jet.compiler.XMLBodyElement;
import org.eclipse.jet.compiler.XMLElement;
import org.eclipse.jet.compiler.XMLEmptyElement;
import org.eclipse.jet.internal.compiler.MethodBodyCreator;
import org.eclipse.jet.taglib.RuntimeTagElement;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.TagLibraryReference;
import org.eclipse.jet.transform.TransformContextExtender;

public class JET2JavaGenerator
implements JET2Template {
    private static final String _jetns_c = "org.eclipse.jet.controlTags";
    private static final String NL = System.getProperty("line.separator");
    private static final TagInfo _td_c_include_80_4 = new TagInfo("c:include", 80, 4, new String[]{"template"}, new String[]{"templates/tagDataDeclarations.jet"});

    private XMLElement[] getAllXMLTags(JET2CompilationUnit cu) {
        final ArrayList result = new ArrayList();
        cu.accept(new DefaultJET2ASTVisitor(){

            public void visit(XMLBodyElement element) {
                result.add(element);
            }

            public void visit(XMLEmptyElement element) {
                result.add(element);
            }
        });
        return result.toArray(new XMLElement[result.size()]);
    }

    private JET2Declaration[] getAllJavaDeclarations(JET2CompilationUnit cu) {
        final ArrayList result = new ArrayList();
        cu.accept(new DefaultJET2ASTVisitor(){

            public void visit(JET2Declaration declaration) {
                result.add(declaration);
            }
        });
        return result.toArray(new JET2Declaration[result.size()]);
    }

    public void generate(JET2Context context, JET2Writer __out) {
        JET2Writer out = __out;
        JET2CompilationUnit cu = (JET2CompilationUnit)context.getVariable("cu");
        JET2Declaration[] allMemberDeclarations = this.getAllJavaDeclarations(cu);
        XMLElement[] allXMLElements = this.getAllXMLTags(cu);
        TagLibraryReference[] tlRefs = cu.getTagLibraryReferences();
        MethodBodyCreator generatedBody = new MethodBodyCreator(TransformContextExtender.getInstance(context).getLoader());
        cu.accept(generatedBody);
        out.write("package ");
        out.write(cu.getOutputJavaPackage());
        out.write(";");
        out.write(NL);
        out.write(NL);
        out.write("import org.eclipse.jet.JET2Context;");
        out.write(NL);
        out.write("import org.eclipse.jet.JET2Template;");
        out.write(NL);
        out.write("import org.eclipse.jet.JET2Writer;");
        out.write(NL);
        if (allXMLElements.length > 0) {
            out.write("import org.eclipse.jet.taglib.RuntimeTagElement;");
            out.write(NL);
            out.write("import org.eclipse.jet.taglib.TagInfo;");
            out.write(NL);
        }
        Iterator i = cu.getImports().iterator();
        while (i.hasNext()) {
            String importName = (String)i.next();
            out.write("import ");
            out.write(importName);
            out.write(";");
            out.write(NL);
        }
        out.write(NL);
        out.write("public class ");
        out.write(cu.getOutputJavaClassName());
        out.write(" implements JET2Template {");
        out.write(NL);
        if (allXMLElements.length > 0) {
            int i2 = 0;
            while (i2 < tlRefs.length) {
                out.write("    public static final String _jetns_");
                out.write(tlRefs[i2].getPrefix());
                out.write(" = \"");
                out.write(tlRefs[i2].getTagLibraryId());
                out.write("\"; //$NON-NLS-1$");
                out.write(NL);
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < allMemberDeclarations.length) {
            out.write(NL);
            out.write(allMemberDeclarations[i3].getJavaContent());
            out.write(NL);
            ++i3;
        }
        out.write(NL);
        out.write("\tpublic ");
        out.write(cu.getOutputJavaClassName());
        out.write("() {");
        out.write(NL);
        out.write("\t\tsuper();");
        out.write(NL);
        out.write("\t}");
        out.write(NL);
        out.write(NL);
        out.write("\tpublic void generate(final JET2Context context, JET2Writer out) {");
        out.write(NL);
        i3 = 0;
        while (i3 < allXMLElements.length) {
            context.setVariable("element", (Object)allXMLElements[i3]);
            RuntimeTagElement _jettag_c_include_80_4 = context.getTagFactory().createRuntimeTag(_jetns_c, "include", "c:include", _td_c_include_80_4);
            _jettag_c_include_80_4.setRuntimeParent(null);
            _jettag_c_include_80_4.setTagInfo(_td_c_include_80_4);
            _jettag_c_include_80_4.doStart(context, out);
            _jettag_c_include_80_4.doEnd();
            ++i3;
        }
        out.write(generatedBody.getBuffer());
        out.write(NL);
        out.write("\t}");
        out.write(NL);
        out.write(NL);
        out.write("}");
        out.write(NL);
    }
}

