/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.CompositeTypesystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTypesystemFactory {
    public static final String EMF_TYPESYSTEM_QUALIFIER = "{emf}";
    public static final String UML_TYPESYSTEM_QUALIFIER = "{uml}";
    public static final String XSD_TYPESYSTEM_QUALIFIER = "{xsd}";
    public static final CompositeTypesystemFactory INSTANCE = new CompositeTypesystemFactory();
    private static final Log _log = LogFactory.getLog(CompositeTypesystemFactory.class);

    public CompositeTypesystem createTypesystem(Set<String> uniqueQualifiers) {
        CompositeTypesystem cts = new CompositeTypesystem();
        try {
            Class<?> umlTsClass = Class.forName("org.eclipse.xtend.backend.types.uml2.UmlTypesystem");
            if (uniqueQualifiers.contains(UML_TYPESYSTEM_QUALIFIER)) {
                cts.register((BackendTypesystem)umlTsClass.newInstance());
            }
        }
        catch (ClassNotFoundException umlTsClass) {
        }
        catch (IllegalArgumentException umlTsClass) {
        }
        catch (Exception umlTsClass) {
            // empty catch block
        }
        try {
            Class<?> xsdTsClass = Class.forName("org.eclipse.xtend.backend.types.xsd.XsdTypesystem");
            if (uniqueQualifiers.contains(XSD_TYPESYSTEM_QUALIFIER)) {
                cts.register((BackendTypesystem)xsdTsClass.newInstance());
            }
        }
        catch (ClassNotFoundException xsdTsClass) {
        }
        catch (IllegalArgumentException xsdTsClass) {
        }
        catch (Exception xsdTsClass) {
            // empty catch block
        }
        try {
            Class<?> emfTsClass = Class.forName("org.eclipse.xtend.backend.types.emf.EmfTypesystem");
            if (uniqueQualifiers.contains(EMF_TYPESYSTEM_QUALIFIER)) {
                cts.register((BackendTypesystem)emfTsClass.newInstance());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cts;
    }

    public CompositeTypesystem createTypesystemFromClass(Set<Class<? extends BackendTypesystem>> typeSystemClasses) {
        CompositeTypesystem cts = new CompositeTypesystem();
        for (Class<? extends BackendTypesystem> tsClass : typeSystemClasses) {
            try {
                cts.register(tsClass.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return cts;
    }

    public CompositeTypesystem createTypesystemFromClassNames(Set<String> typeSystemClassNames) {
        HashSet<Class<? extends BackendTypesystem>> tsClasses = new HashSet<Class<? extends BackendTypesystem>>();
        try {
            for (String className : typeSystemClassNames) {
                Class<?> tsClass = Class.forName(className);
                tsClasses.add(tsClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.createTypesystemFromClass(tsClasses);
    }
}

