/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.common.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ide.ui.api.EEFTab;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.papyrus.sirius.properties.common.utils.SiriusInterpreterHelper;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.ui.properties.internal.EditingContextAdapterWrapper;
import org.eclipse.sirius.ui.properties.internal.dialog.DialogFormContainer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class PropertiesFormDialog
extends FormDialog {
    private IInterpreter interpreter;
    private IVariableManager variableManager;
    private List<EEFPage> eefPages;
    private List<EEFTab> eefTabs;
    private Consumer<IStatus> refreshConsumer;
    private Consumer<IStatus> validateConsumer;
    private EObject target;
    private IMessageManager messageManager;
    private String actionTitle;
    private SiriusInputDescriptor inputDescriptor;

    public PropertiesFormDialog(Shell shell, EObject currentObject, IInterpreter interpreter, IVariableManager variableManager, List<EEFPage> eefPages) {
        super(shell);
        Assert.isNotNull((Object)currentObject, (String)"currentObject should not be null");
        Assert.isNotNull((Object)interpreter, (String)"interpreter should not be null");
        Assert.isNotNull((Object)variableManager, (String)"variableManager should not be null");
        Assert.isNotNull(eefPages, (String)"eefPages should not be null");
        this.target = currentObject;
        this.interpreter = interpreter;
        this.variableManager = variableManager;
        this.eefPages = eefPages;
        this.eefTabs = new ArrayList<EEFTab>();
        this.actionTitle = "";
        this.inputDescriptor = new SiriusInputDescriptor((Object)this.target);
    }

    protected void createFormContent(IManagedForm managedForm) {
        SiriusInterpreterHelper.getInstance().clearValidationVariablesFromInterpreter(this.inputDescriptor);
        String name = this.target.eClass().getName();
        this.getShell().setText(String.valueOf(this.actionTitle) + name);
        managedForm.getForm().setMessage(null, 0);
        this.messageManager = managedForm.getMessageManager();
        managedForm.getMessageManager().setDecorationPosition(16512);
        Composite composite = managedForm.getForm().getForm().getBody();
        composite.setLayout((Layout)new FillLayout());
        int style = 768;
        GridData data = new GridData(style);
        composite.setLayoutData((Object)data);
        CTabFolder tabFolder = new CTabFolder(composite, 2048);
        tabFolder.setMaximized(true);
        this.eefTabs = new ArrayList<EEFTab>();
        CTabItem first = null;
        for (EEFPage eefPage : this.eefPages) {
            IEvaluationResult evaluationResult;
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            if (first == null) {
                first = tabItem;
            }
            if ((evaluationResult = this.interpreter.evaluateExpression(this.variableManager.getVariables(), eefPage.getDescription().getLabelExpression())).getDiagnostic().getSeverity() == 0 && evaluationResult.getValue() instanceof String) {
                String label = (String)evaluationResult.getValue();
                tabItem.setText(label);
            }
            Composite tabContentHolder = new Composite((Composite)tabFolder, 0);
            tabContentHolder.setLayout((Layout)new GridLayout(1, false));
            FormToolkit toolkit = new FormToolkit(tabContentHolder.getDisplay());
            ScrolledForm sform = toolkit.createScrolledForm(tabContentHolder);
            sform.setLayoutData((Object)new GridData(1808));
            ManagedForm managedFormTab = new ManagedForm(toolkit, sform);
            managedFormTab.getMessageManager().setDecorationPosition(16512);
            managedFormTab.getForm().setText(null);
            DialogFormContainer eefContainer = new DialogFormContainer(this.getShell(), managedFormTab.getForm().getForm());
            Composite compositeTab = managedFormTab.getForm().getForm().getBody();
            tabContentHolder.setBackground(compositeTab.getBackground());
            FillLayout layout = new FillLayout();
            compositeTab.setLayout((Layout)layout);
            compositeTab.setLayoutData((Object)data);
            sform.setExpandVertical(false);
            EEFTab eefTab = new EEFTab(eefPage);
            eefTab.createControls(compositeTab, (IEEFFormContainer)eefContainer);
            eefTab.aboutToBeShown();
            eefTab.refresh();
            tabItem.setData((Object)eefTab);
            tabItem.setControl((Control)tabContentHolder);
            PropertiesFormDialog.applyDialogFont((Control)sform.getBody());
            managedFormTab.getForm().reflow(false);
            this.eefTabs.add(eefTab);
        }
        managedForm.getForm().reflow(true);
        this.configureModelChangeRefresh();
    }

    protected void initializeBounds() {
        Point initialLocation = this.getInitialLocation(this.getInitialSize());
        Rectangle r = new Rectangle(initialLocation.x, initialLocation.y / 2, this.getShell().getBounds().width / 2, this.getShell().getBounds().height);
        this.getShell().setBounds(r);
    }

    private void configureModelChangeRefresh() {
        EditingContextAdapter editingContextAdapter;
        if (this.eefPages != null && this.eefPages.size() != 0 && (editingContextAdapter = this.eefPages.get(0).getView().getContextAdapter()) instanceof EditingContextAdapterWrapper) {
            EditingContextAdapterWrapper wrapper = (EditingContextAdapterWrapper)editingContextAdapter;
            this.refreshConsumer = status -> this.refreshDialog();
            wrapper.addPerformedModelChangeConsumer(this.refreshConsumer);
            this.validateConsumer = status -> this.validateTarget(this.target, this.messageManager, null);
            wrapper.addPerformedModelChangeConsumer(this.validateConsumer);
        }
    }

    private void refreshDialog() {
        for (EEFTab eefTab : this.eefTabs) {
            eefTab.refresh();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.setReturnCode(0);
            this.close();
        } else if (1 == buttonId) {
            this.setReturnCode(1);
            this.close();
        }
    }

    public boolean close() {
        boolean result = super.close();
        SiriusInterpreterHelper.getInstance().clearValidationVariablesFromInterpreter(this.inputDescriptor);
        for (EEFPage eefPage : this.eefPages) {
            EditingContextAdapter editingContextAdapter = eefPage.getView().getContextAdapter();
            if (!(editingContextAdapter instanceof EditingContextAdapterWrapper)) continue;
            EditingContextAdapterWrapper wrapper = (EditingContextAdapterWrapper)editingContextAdapter;
            wrapper.removePerformedModelChangeConsumer(this.refreshConsumer);
            wrapper.removePerformedModelChangeConsumer(this.validateConsumer);
        }
        for (EEFTab eefTab : this.eefTabs) {
            eefTab.aboutToBeHidden();
            eefTab.dispose();
        }
        return result;
    }

    public List<EEFTab> getEefTabs() {
        return this.eefTabs;
    }

    public void setActionTitle(String actionTitle) {
        this.actionTitle = actionTitle;
    }

    private void validateTarget(EObject eObject, IMessageManager manager, String message) {
        Diagnostician diagnostician = new Diagnostician(){

            protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                return true;
            }
        };
        Diagnostic validation = diagnostician.validate(eObject);
        int severity = 0;
        if (validation.getSeverity() != 0) {
            manager.removeAllMessages();
            for (Diagnostic diag : validation.getChildren()) {
                if (!diag.getData().contains(eObject)) continue;
                severity = diag.getSeverity() == 4 ? 3 : diag.getSeverity();
                manager.addMessage((Object)diag, diag.getMessage(), null, severity);
            }
        } else {
            manager.removeAllMessages();
            manager.addMessage((Object)eObject, message, null, severity);
        }
    }
}

