/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.CustomizationComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.views.properties.toolsmiths";
    public static final String PREVIEW_ID = "org.eclipse.papyrus.customization.properties.preview";
    public static final String CUSTOMIZATION_PERSPECTIVE_ID = "org.eclipse.papyrus.customization.properties.perspective";
    private static Activator plugin;
    public static LogHelper log;
    private ICustomizationManager fCustomizationManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)plugin);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ICustomizationManager getCustomizationManager() {
        if (this.fCustomizationManager == null) {
            this.fCustomizationManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager((ResourceSet)new ResourceSetImpl());
            this.init(this.fCustomizationManager);
        }
        return this.fCustomizationManager;
    }

    private void init(ICustomizationManager customizationManager) {
        HashSet enabledCustomizations = Sets.newHashSet((Object[])new String[]{"Properties Context", "Properties UI"});
        try {
            ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(customizationManager.getResourceSet());
            List registryAllCustomizations = customCatalog.getRegisteredCustomizations();
            List orderedCustomizationList = registryAllCustomizations.stream().filter(c -> enabledCustomizations.contains(c.getName())).sorted((Comparator<Customization>)new CustomizationComparator()).collect(Collectors.toList());
            customizationManager.getManagedCustomizations().addAll(orderedCustomizationList);
        }
        catch (Throwable e) {
            log.log((IStatus)new Status(4, PLUGIN_ID, "Error initializing customizations", e));
        }
    }

    public IPath getPreferencesPath() {
        return this.getStateLocation();
    }

    public Image getImage(String path) {
        return this.getImage(PLUGIN_ID, path);
    }

    public Image getImage(String pluginId, String path) {
        String key;
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key = pluginId + "/" + path);
        if (image == null) {
            registry.put(key, AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path));
            image = registry.get(key);
        }
        return image;
    }
}

