/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public interface DeltaStrategy {
    public Diff findDiffs(Profile var1, ElementTypeSetConfiguration var2);

    public static interface Diff {
        public List<String> getRemovedStereotypes();

        public List<ImpliedExtension> getRemovedExtensions();

        public Map<String, Stereotype> getRenamedStereotypes();

        public List<Stereotype> getAddedStereotypes();

        public List<ImpliedExtension> getAddedExtensions();

        default public boolean isEmpty() {
            return this.getRemovedStereotypes().isEmpty() && this.getRenamedStereotypes().isEmpty() && this.getAddedStereotypes().isEmpty() && this.getRemovedExtensions().isEmpty() && this.getAddedExtensions().isEmpty();
        }
    }

    public static class DiffImpl
    implements Diff {
        final List<String> removedStereotypes = new ArrayList<String>();
        final Map<String, Stereotype> renamedStereotypes = new HashMap<String, Stereotype>();
        final List<Stereotype> addedStereotypes = new ArrayList<Stereotype>();
        final List<ImpliedExtension> addedExtensions = new ArrayList<ImpliedExtension>();
        final List<ImpliedExtension> removedExtensions = new ArrayList<ImpliedExtension>();

        @Override
        public List<String> getRemovedStereotypes() {
            return this.removedStereotypes;
        }

        @Override
        public Map<String, Stereotype> getRenamedStereotypes() {
            return this.renamedStereotypes;
        }

        @Override
        public List<Stereotype> getAddedStereotypes() {
            return this.addedStereotypes;
        }

        @Override
        public List<ImpliedExtension> getRemovedExtensions() {
            return this.removedExtensions;
        }

        @Override
        public List<ImpliedExtension> getAddedExtensions() {
            return this.addedExtensions;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Removed Stereotypes: " + String.valueOf(this.getRemovedStereotypes())).append('\n');
            builder.append("Added Stereotypes: [" + this.getAddedStereotypes().stream().map(NamedElement::getQualifiedName).collect(Collectors.joining(", "))).append("]\n");
            builder.append("Renamed Stereotypes: " + String.valueOf(this.getRenamedStereotypes())).append('\n');
            builder.append("Added Extensions: [" + this.getAddedExtensions().stream().map(this::toString).collect(Collectors.joining(", "))).append("]\n");
            builder.append("Removed Extensions: [" + this.getRemovedExtensions().stream().map(this::toString).collect(Collectors.joining(", "))).append(']');
            return builder.toString();
        }

        private String toString(ImpliedExtension ext) {
            return ext.getStereotype().getQualifiedName() + " -> " + ext.getMetaclass().getName();
        }
    }
}

