/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.architecture.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.AbsoluteOrder;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.CustomizationReference;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.EMFFacetTreeViewerConfiguration;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.IApplicationRule;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.Redefinition;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.RelativeOrder;
import org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration.util.CustomizationConfigurationValidator;
import org.eclipse.papyrus.emf.facet.architecture.internal.customizationconfiguration.comparators.CustomizationReferenceMerger;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.TreeViewerConfiguration;

public class CustomCustomizationConfigurationValidator
extends CustomizationConfigurationValidator {
    private static final String ARCHITECTURE_FILE_EXTENSION = "architecture";
    public static final CustomizationConfigurationValidator INSTANCE = new CustomCustomizationConfigurationValidator();

    private CustomCustomizationConfigurationValidator() {
    }

    @Override
    public boolean validateEMFFacetTreeViewerConfiguration_checkConfiguration(EMFFacetTreeViewerConfiguration emfFacetTreeViewerConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.checkElement((EObject)emfFacetTreeViewerConfiguration, diagnostics, context, this.getAllConfigurations(emfFacetTreeViewerConfiguration));
    }

    @Override
    public boolean validateAbsoluteOrder_checkAbsoluteOrder(AbsoluteOrder absoluteOrder, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.checkApplicationRule(absoluteOrder, diagnostics, context);
    }

    @Override
    public boolean validateRelativeOrder_checkRelativeOrder(RelativeOrder relativeOrder, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.checkApplicationRule(relativeOrder, diagnostics, context);
    }

    @Override
    public boolean validateRedefinition_checkRedefinition(Redefinition redefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.checkApplicationRule(redefinition, diagnostics, context);
    }

    private boolean checkApplicationRule(IApplicationRule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CustomizationReference custoRef = (CustomizationReference)rule.eContainer();
        EMFFacetTreeViewerConfiguration emfFacetTreeViewerConfiguration = (EMFFacetTreeViewerConfiguration)custoRef.eContainer();
        return this.checkElement(rule, diagnostics, context, this.getAllConfigurations(emfFacetTreeViewerConfiguration));
    }

    @Override
    public boolean validateCustomizationReference_checkCustomizationReference(CustomizationReference customizationReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EMFFacetTreeViewerConfiguration emfFacetTreeViewerConfiguration = (EMFFacetTreeViewerConfiguration)customizationReference.eContainer();
        return this.checkElement(customizationReference, diagnostics, context, this.getAllConfigurations(emfFacetTreeViewerConfiguration));
    }

    private boolean checkElement(EObject toCheck, DiagnosticChain diagnostics, Map<Object, Object> context, Collection<EMFFacetTreeViewerConfiguration> allConfigurations) {
        CustomizationReferenceMerger merger = new CustomizationReferenceMerger(allConfigurations);
        merger.doValidationAndMerge();
        IStatus status = merger.getStatus().get(toCheck);
        this.createDiagnostic(toCheck, diagnostics, context, status);
        return status == null;
    }

    private void createDiagnostic(EObject checkedElement, DiagnosticChain diagnostics, Map<Object, Object> context, IStatus status) {
        if (status != null) {
            if (status instanceof MultiStatus) {
                IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus current = iStatusArray[n2];
                    this.createDiagnostic(checkedElement, diagnostics, context, current);
                    ++n2;
                }
            } else {
                BasicDiagnostic d = new BasicDiagnostic(4, "org.eclipse.papyrus.emf.facet.architecture.customizationconfiguration", status.getCode(), status.getMessage(), new Object[]{checkedElement});
                diagnostics.add((Diagnostic)d);
            }
        }
    }

    private Collection<EMFFacetTreeViewerConfiguration> getAllConfigurations(EMFFacetTreeViewerConfiguration configuration) {
        ArchitectureDescriptionLanguage currentLanguage = (ArchitectureDescriptionLanguage)configuration.eContainer();
        return this.getAllEMFFacetTreeViewerConfigurations(currentLanguage);
    }

    private Collection<EMFFacetTreeViewerConfiguration> getAllEMFFacetTreeViewerConfigurations(ArchitectureDescriptionLanguage adl) {
        return this.getAllTreeViewerConfigurations(adl).stream().filter(EMFFacetTreeViewerConfiguration.class::isInstance).map(EMFFacetTreeViewerConfiguration.class::cast).collect(Collectors.toList());
    }

    private Collection<TreeViewerConfiguration> getAllTreeViewerConfigurations(ArchitectureDescriptionLanguage adl) {
        Collection<Resource> allArchitectures = this.getAllReferencedArchitectureResources(adl.eResource().getResourceSet());
        Collection<ArchitectureDescriptionLanguage> contributionToCurrentADL = this.getAllArchitectureDescriptionLanguageContributions(adl.getId(), this.getAllADLs(allArchitectures));
        ArrayList<TreeViewerConfiguration> treeViewerConfiguration = new ArrayList<TreeViewerConfiguration>();
        for (ArchitectureDescriptionLanguage current : contributionToCurrentADL) {
            treeViewerConfiguration.addAll((Collection<TreeViewerConfiguration>)current.getTreeViewerConfigurations());
        }
        return treeViewerConfiguration;
    }

    private Collection<Resource> getAllReferencedArchitectureResources(ResourceSet resourceSet) {
        ArrayList<Resource> architectures = new ArrayList<Resource>();
        for (Resource current : resourceSet.getResources()) {
            if (!ARCHITECTURE_FILE_EXTENSION.equals(current.getURI().fileExtension()) || current.getContents().size() <= 0) continue;
            architectures.add(current);
        }
        return architectures;
    }

    private Collection<ArchitectureDescriptionLanguage> getAllADLs(Collection<Resource> resources) {
        ArrayList<ArchitectureDescriptionLanguage> allADLs = new ArrayList<ArchitectureDescriptionLanguage>();
        for (Resource current : resources) {
            if (current.getContents().size() <= 0 || !(current.getContents().get(0) instanceof ArchitectureDomain)) continue;
            EObject root = (EObject)current.getContents().get(0);
            for (ArchitectureContext AFcontext : ((ArchitectureDomain)root).getContexts()) {
                if (!(AFcontext instanceof ArchitectureDescriptionLanguage)) continue;
                allADLs.add((ArchitectureDescriptionLanguage)AFcontext);
            }
        }
        return allADLs;
    }

    private Collection<ArchitectureDescriptionLanguage> getAllArchitectureDescriptionLanguageContributions(String adlID, Collection<ArchitectureDescriptionLanguage> allADLs) {
        return allADLs.stream().filter(adl -> adlID.equals(adl.getId())).collect(Collectors.toList());
    }
}

