/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

public class UndefineProfileCommand
extends RecordingCommand {
    private static final String COMMAND_TITLE = "Undefine Profile";
    private final PapyrusDefinitionAnnotation profileDefinition;
    private final Deque<Profile> profilesStack;
    private final Profile rootProfile;

    public UndefineProfileCommand(TransactionalEditingDomain editingDomain, PapyrusDefinitionAnnotation annotation, Profile rootProfile) {
        super(editingDomain, COMMAND_TITLE, null);
        this.rootProfile = rootProfile;
        this.profileDefinition = annotation;
        this.profilesStack = new LinkedList<Profile>(Collections.singleton(rootProfile));
    }

    protected void doExecute() {
        EPackage umlDefinition = this.rootProfile.getDefinition();
        while (!this.profilesStack.isEmpty()) {
            this.handleProfile(this.profilesStack.pop());
        }
        this.handleRemovedProfileDefinition(umlDefinition);
    }

    private void handleRemovedProfileDefinition(EPackage umlDefinition) {
        EAnnotation umlAnnotation;
        PapyrusDefinitionAnnotation currentDefinition = null;
        if (umlDefinition != null) {
            currentDefinition = PapyrusDefinitionAnnotation.parseEAnnotation(umlDefinition.getEAnnotation("PapyrusVersion"));
        }
        if (currentDefinition != null && this.profileDefinition.equals(currentDefinition) && (umlAnnotation = this.rootProfile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && umlAnnotation.getEAnnotation("PapyrusVersion") == null) {
            umlAnnotation.getEAnnotations().add((Object)PapyrusDefinitionAnnotation.UNDEFINED_ANNOTATION.convertToEAnnotation());
        }
    }

    private void handleProfile(Profile profile) {
        EAnnotation umlAnnotation = profile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        EPackage profileDefinition = this.retrieveProfileDefinition(umlAnnotation);
        if (profileDefinition != null) {
            umlAnnotation.getContents().remove((Object)profileDefinition);
        }
        this.pileUpNestedProfiles(profile);
    }

    private EPackage retrieveProfileDefinition(EAnnotation umlAnnotation) {
        Collection packageAnnotations = EcoreUtil.getObjectsByType((Collection)umlAnnotation.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
        Iterator definitionsIterator = packageAnnotations.iterator();
        EPackage packageDefinition = null;
        boolean found = false;
        while (!found && definitionsIterator.hasNext()) {
            packageDefinition = (EPackage)definitionsIterator.next();
            PapyrusDefinitionAnnotation currentDefinition = this.getPapyrusDefinitionAnnotation(packageDefinition);
            found = this.profileDefinition.equals(currentDefinition);
        }
        return found ? packageDefinition : null;
    }

    private PapyrusDefinitionAnnotation getPapyrusDefinitionAnnotation(EPackage profileDefinition) {
        PapyrusDefinitionAnnotation currentDefinition = null;
        EAnnotation profileVersion = profileDefinition.getEAnnotation("PapyrusVersion");
        if (profileDefinition != null) {
            currentDefinition = PapyrusDefinitionAnnotation.parseEAnnotation(profileVersion);
        }
        return currentDefinition;
    }

    private void pileUpNestedProfiles(Profile profile) {
        Collection owningProfiles = EcoreUtil.getObjectsByType((Collection)profile.getNestedPackages(), (EClassifier)UMLPackage.Literals.PROFILE);
        for (Profile owningProfile : owningProfiles) {
            this.profilesStack.addLast(owningProfile);
        }
    }
}

