/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.factory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.toolsmiths.Activator;
import org.eclipse.papyrus.toolsmiths.factory.ExtensionFactory;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizationPluginPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFactoryRegistry {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.toolsmiths.factory";
    public static ExtensionFactoryRegistry instance = new ExtensionFactoryRegistry();
    private final Map<EClass, ExtensionFactory> factories = new HashMap<EClass, ExtensionFactory>();

    private ExtensionFactoryRegistry() {
        this.loadExtensionFactories();
    }

    private void loadExtensionFactories() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ExtensionFactory factory = (ExtensionFactory)e.createExecutableExtension("factory");
                if (!CustomizationPluginPackage.eINSTANCE.getCustomizableElement().isSuperTypeOf(factory.getCustomizableElementClass())) {
                    Activator.log.warn(String.format("The plugin %s contributed an invalid factory (%s).\nThe associated EClass must implement CustomizableElement", e.getContributor().getName(), e.getAttribute("factory")));
                } else {
                    this.factories.put(factory.getCustomizableElementClass(), factory);
                }
            }
            catch (Exception ex) {
                Activator.log.warn(String.format("The plugin %s contributed an invalid factory (%s)", e.getContributor().getName(), e.getAttribute("factory")));
                Activator.log.error((Throwable)ex);
            }
            ++n2;
        }
    }

    public ExtensionFactory getFactory(EClass type) {
        return this.factories.get(type);
    }

    public void registerFactory(EClass forType, ExtensionFactory factory) {
        this.factories.put(forType, factory);
    }

    public Collection<? extends ExtensionFactory> getFactories() {
        return this.factories.values();
    }
}

