/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.QualifiedClassNameProvider;
import xpt.diagram.editpolicies.TextNonResizableEditPolicy;

/**
 * Revisit: [MG]: @Inject extension same-named-api-class -> template extends api-class?
 */
@Singleton
@SuppressWarnings("all")
public class ChildNodeLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private QualifiedClassNameProvider _qualifiedClassNameProvider;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  @Inject
  private TextNonResizableEditPolicy xptTextNonResizable;
  
  public CharSequence className(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  public CharSequence constructor(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDragTrackerBody(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (request instanceof org.eclipse.gef.requests.SelectionRequest && ((org.eclipse.gef.requests.SelectionRequest) request).getLastButtonPressed() == 3) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx(this);");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createDefaultEditPoliciesBody(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.SEMANTIC_ROLE, new ");
    CharSequence _itemSemanticEditPolicyQualifiedClassName = this._qualifiedClassNameProvider.getItemSemanticEditPolicyQualifiedClassName(it);
    _builder.append(_itemSemanticEditPolicyQualifiedClassName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new ");
    CharSequence _qualifiedClassName = this.xptTextNonResizable.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.COMPONENT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ListItemComponentEditPolicy());");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());");
    _builder.newLine();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    CharSequence _additionalEditPolicies = this.additionalEditPolicies(it);
    _builder.append(_additionalEditPolicies);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additionalEditPolicies(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence handleNotificationEventBody(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Object feature = event.getFeature();");
    _builder.newLine();
    CharSequence _handleText = this.xptEditpartsCommon.handleText(it);
    _builder.append(_handleText);
    _builder.newLineIfNotEmpty();
    _builder.append("super.handleNotificationEvent(event);");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isSelectable(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isSelectable() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getFigure().isShowing();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
