/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Artem Tikhomirov (Borland) - refactoring (https://bugs.eclipse.org/230014)
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package xpt.providers;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Set;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMeasurable;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricContainer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.papyrus.gmf.internal.common.codegen.Conversions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import plugin.Activator;
import xpt.Common;
import xpt.Common_qvto;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.VisualIDRegistry;
import xpt.expressions.getExpression;

@Singleton
@SuppressWarnings("all")
public class MetricProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Metrics_qvto _metrics_qvto;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Inject
  private MetricsResultView xptMetricsResultView;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private getExpression xptGetExpression;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;
  
  @MetaDef
  public CharSequence invokeCalcMethod(final GenMetricRule it, final String accessor, final boolean isSpecific) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it.getContainer().getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    String _calcMethodName = this._metrics_qvto.calcMethodName(it);
    _builder.append(_calcMethodName);
    _builder.append("(");
    {
      if ((!isSpecific)) {
        _builder.append("(");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getTarget().getContext());
        _builder.append(_QualifiedClassName);
        _builder.append(") ");
      }
    }
    _builder.append(accessor);
    _builder.append(")");
    return _builder;
  }
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _metricProviderClassName = it.getMetricProviderClassName();
    _builder.append(_metricProviderClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _providersPackageName = it.getProvidersPackageName();
    _builder.append(_providersPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence MetricProvider(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static class MetricsAction extends org.eclipse.jface.action.Action {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("private org.eclipse.ui.IWorkbenchPage page;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public MetricsAction(org.eclipse.ui.IWorkbenchPage page) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("setText(\"Metrics\");");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("this.page = page;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.ui.IWorkbenchPart workbenchPart = page.getActivePart();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.ui.IViewPart metricsView = null;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("metricsView = page.findView(");
    CharSequence _resultViewID = this.resultViewID(it);
    _builder.append(_resultViewID, "\t\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("if (metricsView == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("metricsView = page.showView(");
    CharSequence _resultViewID_1 = this.resultViewID(it);
    _builder.append(_resultViewID_1, "\t\t\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (metricsView != null && workbenchPart instanceof org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("final org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart part = (org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) workbenchPart;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("((ResultView) metricsView).setInput(part);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("page.activate(metricsView);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} catch (org.eclipse.ui.PartInitException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t\t\t");
    _builder.append(".getInstance().logError(\"Diagram metric view failure\", e); ");
    CharSequence _nonNLS = this._common.nonNLS(
      1);
    _builder.append(_nonNLS, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _calculateMetricsMethods = this.calculateMetricsMethods(it);
    _builder.append(_calculateMetricsMethods);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _formatNotationElementNameMethod = this.formatNotationElementNameMethod(it);
    _builder.append(_formatNotationElementNameMethod);
    _builder.newLineIfNotEmpty();
    CharSequence _formatSemanticElementNameMethod = this.formatSemanticElementNameMethod(it);
    _builder.append(_formatSemanticElementNameMethod);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _metricsClasses = this.metricsClasses(it);
    _builder.append(_metricsClasses);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _keysAndToolTipsMethods = this.keysAndToolTipsMethods(it.getEditorGen().getMetrics());
    _builder.append(_keysAndToolTipsMethods);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      final Function1<GenMetricRule, Boolean> _function = new Function1<GenMetricRule, Boolean>() {
        @Override
        public Boolean apply(final GenMetricRule m) {
          return Boolean.valueOf((((!Objects.equal(m.getRule(), null)) && (!Objects.equal(m.getTarget(), null))) && (!Objects.equal(m.getTarget().getContext(), null))));
        }
      };
      Iterable<GenMetricRule> _filter = IterableExtensions.<GenMetricRule>filter(it.getEditorGen().getMetrics().getMetrics(), _function);
      for(final GenMetricRule m : _filter) {
        CharSequence _metricCalcMethod = this.metricCalcMethod(m);
        _builder.append(_metricCalcMethod);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    CharSequence _Class = this.xptMetricsResultView.Class(it);
    _builder.append(_Class);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _additions = this.additions(it);
    _builder.append(_additions);
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence resultViewQualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".");
    CharSequence _className = this.xptMetricsResultView.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence resultViewID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _resultViewQualifiedClassName = this.resultViewQualifiedClassName(it);
    _builder.append(_resultViewQualifiedClassName);
    _builder.append(".VIEW_ID");
    return _builder;
  }
  
  public CharSequence calculateMetricsMethods(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static java.util.List calculateMetrics(org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart diagramPart) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart = diagramPart.getDiagramEditPart();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (java.util.List) diagramPart.getDiagramEditPart().getEditingDomain().runExclusive(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.emf.transaction.RunnableWithResult.Impl() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = diagramEditPart.getDiagramView();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.ArrayList<ElementMetrics> metrics = new java.util.ArrayList<ElementMetrics>(50); ");
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenMetricRule>notEmpty(this._metrics_qvto.getNotationMetrics(it.getEditorGen().getMetrics()));
      if (_notEmpty) {
        _builder.append("\t\t");
        _builder.append("calculateNotationElementMetrics(diagram, metrics);");
        _builder.newLine();
      }
    }
    {
      boolean _notEmpty_1 = this._common_qvto.<GenMetricRule>notEmpty(this._metrics_qvto.getDiagramMetrics(it.getEditorGen().getMetrics()));
      if (_notEmpty_1) {
        _builder.append("\t\t");
        _builder.append("calculateDiagramElementMetrics(diagram, metrics);");
        _builder.newLine();
      }
    }
    {
      boolean _notEmpty_2 = this._common_qvto.<GenMetricRule>notEmpty(this._metrics_qvto.getDomainMetrics(it.getEditorGen().getMetrics()));
      if (_notEmpty_2) {
        _builder.append("\t\t");
        _builder.append("calculateSemanticElementMetrics(diagramEditPart, metrics);");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("setResult(metrics);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (InterruptedException e) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return java.util.Collections.EMPTY_LIST;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      boolean _notEmpty_3 = this._common_qvto.<GenMetricRule>notEmpty(this._metrics_qvto.getNotationMetrics(it.getEditorGen().getMetrics()));
      if (_notEmpty_3) {
        CharSequence _calcNotationMetricsMethod = this.calcNotationMetricsMethod(it.getEditorGen());
        _builder.append(_calcNotationMetricsMethod);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty_4 = this._common_qvto.<GenMetricRule>notEmpty(this._metrics_qvto.getDiagramMetrics(it.getEditorGen().getMetrics()));
      if (_notEmpty_4) {
        CharSequence _calcDiagramMetricsMethod = this.calcDiagramMetricsMethod(it.getEditorGen());
        _builder.append(_calcDiagramMetricsMethod);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty_5 = this._common_qvto.<GenMetricRule>notEmpty(this._metrics_qvto.getDomainMetrics(it.getEditorGen().getMetrics()));
      if (_notEmpty_5) {
        CharSequence _calcDomainMetricsMethod = this.calcDomainMetricsMethod(it.getEditorGen());
        _builder.append(_calcDomainMetricsMethod);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence metricsClasses(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static class ElementMetrics {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final Metric[] metrics;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final String targetElementQName;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final org.eclipse.swt.graphics.Image elementImage;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("String diagramElementID; ");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("ElementMetrics(org.eclipse.emf.ecore.EObject target, String name, Metric[] metrics) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence __assert = this._common._assert("metrics.length > 0");
    _builder.append(__assert, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence __assert_1 = this._common._assert("name != null");
    _builder.append(__assert_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.metrics = metrics;\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.targetElementQName = name;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EClass imageTarget = target.eClass();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (target instanceof org.eclipse.gmf.runtime.notation.View) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View viewTarget = (org.eclipse.gmf.runtime.notation.View) target;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (\"\".equals(viewTarget.getType()) && viewTarget.getElement() != null) { ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("imageTarget = viewTarget.getElement().eClass();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.elementImage = ");
    CharSequence _imageAccessor = this.getImageAccessor(it, "imageTarget");
    _builder.append(_imageAccessor, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Metric getMetricByKey(String key) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (int i = 0; i < metrics.length; i++) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (metrics[i].key.equals(key)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return metrics[i]; ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7);
    _builder.newLineIfNotEmpty();
    _builder.append("private static class Metric implements Comparable {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final String key;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_9, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final Double value;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_10, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final Double lowLimit;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_11, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final Double highLimit;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_12, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("final String displayValue;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_13, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Metric(String key, Double value) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this(key, value, null, null);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_14 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_14, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Metric(String key, Double value, Double low, Double high) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence __assert_2 = this._common._assert("key != null");
    _builder.append(__assert_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.key = key;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.value = value;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.lowLimit = low;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.highLimit = high;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.displayValue = (value != null) ? java.text.NumberFormat.getInstance().format(value) : \"null\"; //$NON-NLS-1$");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_15 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_15, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public int compareTo(Object other) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Metric otherMetric = (Metric) other;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (value != null && otherMetric.value != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (value.longValue() < otherMetric.value.longValue()) ? -1");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append(": (value.longValue() == otherMetric.value.longValue() ? 0 : 1);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return (value == null && otherMetric.value == null) ? 0");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append(": (value == null) ? -1 : 1;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getImageAccessor(final GenDiagram it, final String imageClassVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    _builder.append(".getImage(");
    _builder.append(imageClassVar);
    _builder.append(")");
    return _builder;
  }
  
  public CharSequence calcNotationMetricsMethod(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static void calculateNotationElementMetrics(org.eclipse.gmf.runtime.notation.Diagram diagram, java.util.List<ElementMetrics> metricsList) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ElementMetrics row = null;");
    _builder.newLine();
    _builder.append("\t");
    final Function1<GenMetricRule, Boolean> _function = new Function1<GenMetricRule, Boolean>() {
      @Override
      public Boolean apply(final GenMetricRule m) {
        GenMeasurable _target = m.getTarget();
        String _name = ((GenNotationElementTarget) _target).getElement().getEcoreClass().getName();
        return Boolean.valueOf(Objects.equal(_name, "Diagram"));
      }
    };
    Iterable<GenMetricRule> diagramMetrics = IterableExtensions.<GenMetricRule>filter(this._metrics_qvto.getNotationMetrics(it.getMetrics()), _function);
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty = this._common_qvto.<GenMetricRule>notEmpty(diagramMetrics);
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("row = new ElementMetrics(diagram, formatViewName(diagram), new Metric[] {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        {
          boolean _hasElements = false;
          for(final GenMetricRule m : diagramMetrics) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",\n", "\t\t");
            }
            CharSequence _metricResult = this.metricResult(m, "diagram", false);
            _builder.append(_metricResult, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("row.diagramElementID = diagram.eResource().getURIFragment(diagram);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("metricsList.add(row);");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    final Function1<GenMetricRule, GenClass> _function_1 = new Function1<GenMetricRule, GenClass>() {
      @Override
      public GenClass apply(final GenMetricRule m) {
        GenMeasurable _target = m.getTarget();
        return ((GenNotationElementTarget) _target).getElement();
      }
    };
    Set<GenClass> notationTargets = IterableExtensions.<GenClass>toSet(IterableExtensions.<GenMetricRule, GenClass>map(this._metrics_qvto.getNotationMetrics(it.getMetrics()), _function_1));
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator it<org.eclipse.emf.ecore.EObjectzz> = diagram.eAllContents(); it.hasNext(); ) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Object next = it.next();");
    _builder.newLine();
    {
      Iterable<GenClass> _filter = Iterables.<GenClass>filter(notationTargets, GenClass.class);
      for(final GenClass nt : _filter) {
        _builder.append("\t\t");
        _builder.append("if (");
        CharSequence _IsInstance = this.xptMetaModel.IsInstance(nt, "next");
        _builder.append(_IsInstance, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        String _lowerCase = nt.getEcoreClass().getName().toLowerCase();
        String _plus = ("_" + _lowerCase);
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(nt, _plus, "next", true);
        _builder.append(_DeclareAndAssign, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("row = new ElementMetrics(");
        String _lowerCase_1 = nt.getEcoreClass().getName().toLowerCase();
        String _plus_1 = ("_" + _lowerCase_1);
        _builder.append(_plus_1, "\t\t\t");
        _builder.append(", formatViewName(");
        String _lowerCase_2 = nt.getEcoreClass().getName().toLowerCase();
        String _plus_2 = ("_" + _lowerCase_2);
        _builder.append(_plus_2, "\t\t\t");
        _builder.append("), new Metric[] {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<GenMetricRule, Boolean> _function_2 = new Function1<GenMetricRule, Boolean>() {
            @Override
            public Boolean apply(final GenMetricRule m) {
              GenMeasurable _target = m.getTarget();
              GenClass _element = ((GenNotationElementTarget) _target).getElement();
              return Boolean.valueOf(Objects.equal(_element, nt));
            }
          };
          Iterable<GenMetricRule> _filter_1 = IterableExtensions.<GenMetricRule>filter(this._metrics_qvto.getNotationMetrics(it.getMetrics()), _function_2);
          boolean _hasElements_1 = false;
          for(final GenMetricRule m_1 : _filter_1) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder.appendImmediate(",", "\t\t\t");
            }
            _builder.append("\t\t");
            _builder.append("\t");
            String _lowerCase_3 = nt.getEcoreClass().getName().toLowerCase();
            String _plus_3 = ("_" + _lowerCase_3);
            CharSequence _metricResult_1 = this.metricResult(m_1, _plus_3, false);
            _builder.append(_metricResult_1, "\t\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("row.diagramElementID = ");
        String _lowerCase_4 = nt.getEcoreClass().getName().toLowerCase();
        String _plus_4 = ("_" + _lowerCase_4);
        _builder.append(_plus_4, "\t\t\t");
        _builder.append(".eResource().getURIFragment(");
        String _lowerCase_5 = nt.getEcoreClass().getName().toLowerCase();
        String _plus_5 = ("_" + _lowerCase_5);
        _builder.append(_plus_5, "\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("metricsList.add(row);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence calcDiagramMetricsMethod(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static void calculateDiagramElementMetrics(org.eclipse.gmf.runtime.notation.Diagram diagram, java.util.List<ElementMetrics> metricsList) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject next = diagram;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.Iterator/*<EObject>*/ it = diagram.eAllContents();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("do {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (next instanceof org.eclipse.gmf.runtime.notation.View) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) next;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("final int vid = ");
    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getDiagram());
    _builder.append(_visualIDMethodCall, "\t\t\t");
    _builder.append("(view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("java.util.ArrayList/*<Metric>*/ res = new java.util.ArrayList/*<Metric>*/(5);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("switch (vid) {");
    _builder.newLine();
    {
      final Function1<GenMetricRule, EList<GenCommonBase>> _function = new Function1<GenMetricRule, EList<GenCommonBase>>() {
        @Override
        public EList<GenCommonBase> apply(final GenMetricRule m) {
          GenMeasurable _target = m.getTarget();
          return ((GenDiagramElementTarget) _target).getElement();
        }
      };
      Iterable<GenCommonBase> _flatten = Iterables.<GenCommonBase>concat(IterableExtensions.<GenMetricRule, EList<GenCommonBase>>map(this._metrics_qvto.getDiagramMetrics(it.getMetrics()), _function));
      for(final GenCommonBase cb : _flatten) {
        _builder.append("\t\t\t");
        _builder.append("case ");
        CharSequence _visualID = VisualIDRegistry.visualID(cb);
        _builder.append(_visualID, "\t\t\t");
        _builder.append(" : {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<GenMetricRule, Boolean> _function_1 = new Function1<GenMetricRule, Boolean>() {
            @Override
            public Boolean apply(final GenMetricRule mm) {
              GenMeasurable _target = mm.getTarget();
              return Boolean.valueOf(((GenDiagramElementTarget) _target).getElement().contains(cb));
            }
          };
          Iterable<GenMetricRule> _filter = IterableExtensions.<GenMetricRule>filter(this._metrics_qvto.getDiagramMetrics(it.getMetrics()), _function_1);
          for(final GenMetricRule m : _filter) {
            _builder.append("\t\t\t");
            _builder.append("res.add(");
            CharSequence _metricResult = this.metricResult(m, "view", true);
            _builder.append(_metricResult, "\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (!res.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("ElementMetrics row = new ElementMetrics(view, formatViewName(view), (Metric[]) res.toArray(new Metric[res.size()]));");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("row.diagramElementID = view.eResource().getURIFragment(view);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("metricsList.add(row);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("next = it.hasNext() ? (org.eclipse.emf.ecore.EObject) it.next() : null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} while (next != null);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * FIXME:
   * 		for now, keep approach from old implementation, i.e. iterate content
   * 		of element associated with diagram. Smarter approach would be
   * 		iteration over diagram elements, then accessing their respective
   * 		semantic elements (if set), and collecting metrics for them.
   */
  public CharSequence calcDomainMetricsMethod(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(
      "NOTE: metrics are being collected for domain elements contained in the semantic element associated with diagram view, actual diagram content (elements present there) is not taken into account.");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static void calculateSemanticElementMetrics(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart, java.util.List<ElementMetrics> metricsList) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram = diagramEditPart.getDiagramView();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject next = diagram.getElement();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.Iterator/*<EObject>*/ it = next != null ? next.eAllContents() : java.util.Collections.EMPTY_LIST.iterator();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.HashMap<org.eclipse.emf.ecore.EObject, ElementMetrics> target2row = new java.util.HashMap<org.eclipse.emf.ecore.EObject, ElementMetrics>(); ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("while (next != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.util.ArrayList<Metric> res = new java.util.ArrayList<Metric>(5); ");
    _builder.newLine();
    {
      final Function1<GenMetricRule, GenMeasurable> _function = new Function1<GenMetricRule, GenMeasurable>() {
        @Override
        public GenMeasurable apply(final GenMetricRule m) {
          return m.getTarget();
        }
      };
      final Function1<GenDomainElementTarget, GenClass> _function_1 = new Function1<GenDomainElementTarget, GenClass>() {
        @Override
        public GenClass apply(final GenDomainElementTarget t) {
          return t.getElement();
        }
      };
      Iterable<GenClass> _map = IterableExtensions.<GenDomainElementTarget, GenClass>map(Iterables.<GenDomainElementTarget>filter(ListExtensions.<GenMetricRule, GenMeasurable>map(it.getMetrics().getMetrics(), _function), GenDomainElementTarget.class), _function_1);
      for(final GenClass e : _map) {
        _builder.append("\t\t");
        _builder.append("if (");
        CharSequence _MetaClass = this.xptMetaModel.MetaClass(e);
        _builder.append(_MetaClass, "\t\t");
        _builder.append(".isInstance(next)) {");
        _builder.newLineIfNotEmpty();
        {
          final Function1<GenMetricRule, Boolean> _function_2 = new Function1<GenMetricRule, Boolean>() {
            @Override
            public Boolean apply(final GenMetricRule m) {
              GenClassifier _context = m.getTarget().getContext();
              return Boolean.valueOf(Objects.equal(_context, e));
            }
          };
          Iterable<GenMetricRule> _filter = IterableExtensions.<GenMetricRule>filter(it.getMetrics().getMetrics(), _function_2);
          for(final GenMetricRule m : _filter) {
            _builder.append("\t\t");
            _builder.append("res.add(");
            CharSequence _metricResult = this.metricResult(m, "next", true);
            _builder.append(_metricResult, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("if (!res.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("ElementMetrics row = new ElementMetrics(next, formatElementName(next), (Metric[]) res.toArray(new Metric[res.size()]));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("metricsList.add(row);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("target2row.put(next, row);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("next = it.hasNext() ? (org.eclipse.emf.ecore.EObject) it.next() : null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!target2row.isEmpty()) { // list was modified, need to process only semantic metrics");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// bind semantic elements to notation");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".LazyElement2ViewMap element2ViewMap = new ");
    CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".LazyElement2ViewMap(diagram, target2row.keySet());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator it2 = target2row.entrySet().iterator(); it2.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("java.util.Map.Entry entry = (java.util.Map.Entry) it2.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject semanticElement = (org.eclipse.emf.ecore.EObject) entry.getKey();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View targetView = ");
    CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName_2, "\t\t\t");
    _builder.append(".findView(diagramEditPart, semanticElement, element2ViewMap);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("ElementMetrics elementMetrics = (ElementMetrics) entry.getValue();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("elementMetrics.diagramElementID = targetView.eResource().getURIFragment(targetView);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence formatNotationElementNameMethod(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static String formatViewName(org.eclipse.gmf.runtime.notation.View viewTarget) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("StringBuffer notationQNameBuf = new StringBuffer();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("notationQNameBuf.append(formatElementName(viewTarget));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (viewTarget.getElement() != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("notationQNameBuf.append(\"->\").append(formatElementName(viewTarget.getElement()));\t");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int visualID = ");
    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t");
    _builder.append("(viewTarget);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("notationQNameBuf.append(\'[\').append(visualID < 0 ? Integer.toString(System.identityHashCode(viewTarget)) : Integer.toString(visualID)).append(\']\');");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return notationQNameBuf.toString();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence formatSemanticElementNameMethod(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static String formatElementName(org.eclipse.emf.ecore.EObject object) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(object, true);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence metricCalcMethod(final GenMetricRule it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static");
    _builder.append(" Double ");
    String _calcMethodName = this._metrics_qvto.calcMethodName(it);
    _builder.append(_calcMethodName);
    _builder.append("(");
    CharSequence _calcMethodArgs = this.calcMethodArgs(it.getTarget(), it);
    _builder.append(_calcMethodArgs);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _calcMethodBody = this.calcMethodBody(it.getRule().getProvider(), it);
    _builder.append(_calcMethodBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _calcMethodArgs(final GenMeasurable it, final GenMetricRule metric) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unrecognized metric target: " + it));
    return _builder;
  }
  
  protected CharSequence _calcMethodArgs(final GenDomainElementTarget it, final GenMetricRule metric) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getElement());
    _builder.append(_QualifiedClassName);
    _builder.append(" target");
    return _builder;
  }
  
  /**
   * We do check all elements to be of specific kind to provide most narrow type cast
   * However, GenDiagramElementTargetImpl#getContext uses first element's notation class only
   */
  protected CharSequence _calcMethodArgs(final GenDiagramElementTarget it, final GenMetricRule metric) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.notation.");
    {
      boolean _allOfType = this.allOfType(it, GenNode.class);
      if (_allOfType) {
        _builder.append("Node");
      } else {
        boolean _allOfType_1 = this.allOfType(it, GenLink.class);
        if (_allOfType_1) {
          _builder.append("Edge");
        } else {
          boolean _allOfType_2 = this.allOfType(it, 
            GenDiagram.class);
          if (_allOfType_2) {
            _builder.append("Diagram");
          } else {
            _builder.append("View");
          }
        }
      }
    }
    _builder.append(" target");
    return _builder;
  }
  
  public boolean allOfType(final GenDiagramElementTarget it, final Class<? extends GenCommonBase> type) {
    final Function1<GenCommonBase, Boolean> _function = new Function1<GenCommonBase, Boolean>() {
      @Override
      public Boolean apply(final GenCommonBase e) {
        return Boolean.valueOf(MetricProvider.this._common_qvto.oclIsKindOf(e, type));
      }
    };
    return IterableExtensions.<GenCommonBase>forall(it.getElement(), _function);
  }
  
  /**
   * Note, use of QualifiedClassName here assumes it always works the same for the notation model, regardless of 'dynamic model' use (i.e. always gives qName of oeg.runtime.notation.* Java class)
   */
  protected CharSequence _calcMethodArgs(final GenNotationElementTarget it, final GenMetricRule metric) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getElement());
    _builder.append(_QualifiedClassName);
    _builder.append(" target");
    return _builder;
  }
  
  protected CharSequence _calcMethodBody(final GenExpressionProviderBase it, final GenMetricRule metric) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(
      ("No idea how to calculate metric\'s value for " + it));
    return _builder;
  }
  
  protected CharSequence _calcMethodBody(final GenExpressionInterpreter it, final GenMetricRule metric) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Object val = ");
    CharSequence _expression = this.xptGetExpression.getExpression(it, metric.getRule(), metric.getTarget().getContext());
    _builder.append(_expression);
    _builder.append(".evaluate(target);");
    _builder.newLineIfNotEmpty();
    _builder.append("if (val instanceof Number) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return val.getClass() == Double.class ? (Double) val : new Double(((Number) val).doubleValue());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("return null;");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _calcMethodBody(final GenJavaExpressionProvider it, final GenMetricRule metric) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((it.isInjectExpressionBody() && (!StringExtensions.isNullOrEmpty(metric.getRule().getBody())))) {
        String _body = metric.getRule().getBody();
        _builder.append(_body);
        _builder.newLineIfNotEmpty();
      } else {
        if ((it.isThrowException() || (it.isInjectExpressionBody() && StringExtensions.isNullOrEmpty(metric.getRule().getBody())))) {
          _builder.append("// TODO: implement this method");
          _builder.newLine();
          _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
          _builder.newLine();
          _builder.append("throw new java.lang.UnsupportedOperationException(\"No user java implementation provided\"); ");
          CharSequence _nonNLS = this._common.nonNLS(1);
          _builder.append(_nonNLS);
          _builder.newLineIfNotEmpty();
        } else {
          _builder.append("return new Double(Double.NaN);");
          _builder.newLine();
        }
      }
    }
    return _builder;
  }
  
  /**
   * Next two methods should return arrays of identical length, hence are placed into a single template
   */
  public CharSequence keysAndToolTipsMethods(final GenMetricContainer it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static String[] getMetricKeys() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new String[] {");
    _builder.newLine();
    _builder.append("\t\t");
    {
      EList<GenMetricRule> _metrics = it.getMetrics();
      boolean _hasElements = false;
      for(final GenMetricRule m : _metrics) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",\n", "\t\t");
        }
        String _stringLiteral = this.toStringLiteral(m.getKey());
        _builder.append(_stringLiteral, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private static String[] getMetricToolTips() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new String[] {");
    _builder.newLine();
    _builder.append("\t\t");
    {
      EList<GenMetricRule> _metrics_1 = it.getMetrics();
      boolean _hasElements_1 = false;
      for(final GenMetricRule m_1 : _metrics_1) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder.appendImmediate(",\n", "\t\t");
        }
        CharSequence _singleMetricTooltip = this.singleMetricTooltip(m_1);
        _builder.append(_singleMetricTooltip, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("} ");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence singleMetricTooltip(final GenMetricRule m) {
    StringConcatenation _builder = new StringConcatenation();
    String _stringLiteral = this.toStringLiteral(this.nameOrKey(m));
    _builder.append(_stringLiteral);
    {
      String _description = m.getDescription();
      boolean _notEquals = (!Objects.equal(_description, null));
      if (_notEquals) {
        _builder.append(" + \'\\n\' + ");
        String _stringLiteral_1 = this.toStringLiteral(m.getDescription());
        _builder.append(_stringLiteral_1);
        _builder.append(" + \'\\n\'");
      }
    }
    {
      Double _lowLimit = m.getLowLimit();
      boolean _notEquals_1 = (!Objects.equal(null, _lowLimit));
      if (_notEquals_1) {
        _builder.append(" + ");
        Double _lowLimit_1 = m.getLowLimit();
        String _plus = ("low: " + _lowLimit_1);
        String _stringLiteral_2 = this.toStringLiteral(_plus);
        _builder.append(_stringLiteral_2);
      }
    }
    {
      Double _highLimit = m.getHighLimit();
      boolean _notEquals_2 = (!Objects.equal(null, _highLimit));
      if (_notEquals_2) {
        _builder.append(" + ");
        Double _highLimit_1 = m.getHighLimit();
        String _plus_1 = ("high: " + _highLimit_1);
        String _stringLiteral_3 = this.toStringLiteral(_plus_1);
        _builder.append(_stringLiteral_3);
      }
    }
    return _builder;
  }
  
  protected String nameOrKey(final GenMetricRule metric) {
    String _xifexpression = null;
    String _name = metric.getName();
    boolean _equals = Objects.equal(_name, null);
    if (_equals) {
      _xifexpression = metric.getKey();
    } else {
      _xifexpression = metric.getName();
    }
    return _xifexpression;
  }
  
  protected CharSequence doubleOrNull(final Double d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _equals = Objects.equal(d, null);
      if (_equals) {
        _builder.append("null");
      } else {
        _builder.append("new Double(");
        _builder.append(d);
        _builder.append(")");
      }
    }
    return _builder;
  }
  
  protected CharSequence castIfNeeded(final GenMetricRule it, final String targetAccessor, final boolean isJustEObject) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((isJustEObject && 
        this._common_qvto.oclIsKindOf(it.getTarget().getContext(), GenClass.class))) {
        GenClassifier _context = it.getTarget().getContext();
        CharSequence _CastEObject = this.xptMetaModel.CastEObject(((GenClass) _context), targetAccessor);
        _builder.append(_CastEObject);
      } else {
        _builder.append(targetAccessor);
      }
    }
    return _builder;
  }
  
  public String toStringLiteral(final String key) {
    return Conversions.toStringLiteral(key);
  }
  
  public CharSequence metricResult(final GenMetricRule it, final String targetAccessor, final boolean isJustEObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new Metric(");
    String _stringLiteral = this.toStringLiteral(it.getKey());
    _builder.append(_stringLiteral);
    _builder.append(", ");
    String _calcMethodName = this._metrics_qvto.calcMethodName(it);
    _builder.append(_calcMethodName);
    _builder.append("(");
    CharSequence _castIfNeeded = this.castIfNeeded(it, targetAccessor, isJustEObject);
    _builder.append(_castIfNeeded);
    _builder.append("), ");
    CharSequence _doubleOrNull = this.doubleOrNull(
      it.getLowLimit());
    _builder.append(_doubleOrNull);
    _builder.append(", ");
    CharSequence _doubleOrNull_1 = this.doubleOrNull(it.getHighLimit());
    _builder.append(_doubleOrNull_1);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence calcMethodArgs(final GenMeasurable it, final GenMetricRule metric) {
    if (it instanceof GenDiagramElementTarget) {
      return _calcMethodArgs((GenDiagramElementTarget)it, metric);
    } else if (it instanceof GenDomainElementTarget) {
      return _calcMethodArgs((GenDomainElementTarget)it, metric);
    } else if (it instanceof GenNotationElementTarget) {
      return _calcMethodArgs((GenNotationElementTarget)it, metric);
    } else if (it != null) {
      return _calcMethodArgs(it, metric);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, metric).toString());
    }
  }
  
  public CharSequence calcMethodBody(final GenExpressionProviderBase it, final GenMetricRule metric) {
    if (it instanceof GenExpressionInterpreter) {
      return _calcMethodBody((GenExpressionInterpreter)it, metric);
    } else if (it instanceof GenJavaExpressionProvider) {
      return _calcMethodBody((GenJavaExpressionProvider)it, metric);
    } else if (it != null) {
      return _calcMethodBody(it, metric);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, metric).toString());
    }
  }
}
