/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.internal.ui;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.emf.internal.resource.CrossReferenceIndex;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IndexManager;
import org.eclipse.papyrus.infra.emf.resource.ICrossReferenceIndex;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;

public class ControlledUnitLabelDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private ICrossReferenceIndex index = null;
    private Runnable unregisterHandler;

    public void dispose() {
        try {
            if (this.unregisterHandler != null) {
                this.unregisterHandler.run();
                this.unregisterHandler = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        if (IndexManager.getInstance().isStarted()) {
            if (element instanceof IFile) {
                this.checkIndex();
                this.decorateFile((IFile)element, decoration);
            } else if (element instanceof IPapyrusFile) {
                this.checkIndex();
                this.decorateFile((IPapyrusFile)element, decoration);
            }
        }
    }

    private void checkIndex() {
        if (this.index == null) {
            this.index = CrossReferenceIndex.getInstance();
            this.unregisterHandler = ((CrossReferenceIndex)this.index).onIndexChanged(__ -> this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this)), (Executor)CoreExecutors.getUIExecutorService());
        }
    }

    private void decorateFile(IFile file, IDecoration decoration) {
        ListenableFuture<SubunitKind> futureKind = this.getSubunitKind(file);
        if (futureKind.isDone()) {
            SubunitKind kind = (SubunitKind)((Object)Futures.getUnchecked(futureKind));
            if (kind != SubunitKind.NONE) {
                this.addOverlay(decoration, kind);
            }
        } else {
            futureKind.addListener(this.postUpdate(file), (Executor)CoreExecutors.getUIExecutorService());
        }
    }

    private void decorateFile(IPapyrusFile file, IDecoration decoration) {
        ArrayList kindFutures = Lists.newArrayListWithExpectedSize((int)3);
        IResource[] iResourceArray = file.getAssociatedResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1) {
                kindFutures.add(this.getSubunitKind((IFile)resource));
            }
            ++n2;
        }
        ListenableFuture futureKinds = Futures.allAsList((Iterable)kindFutures);
        if (futureKinds.isDone()) {
            SubunitKind kind = SubunitKind.max((Collection)Futures.getUnchecked((Future)futureKinds));
            if (kind != SubunitKind.NONE) {
                this.addOverlay(decoration, kind);
            }
        } else {
            futureKinds.addListener(this.postUpdate(file), (Executor)CoreExecutors.getUIExecutorService());
        }
    }

    private void addOverlay(IDecoration decoration, SubunitKind kind) {
        decoration.addOverlay(kind.getIcon(), 1);
    }

    private ListenableFuture<SubunitKind> getSubunitKind(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true);
        ListenableFuture parents = this.index.getParentsAsync(uri, false);
        ListenableFuture isShard = this.index.isShardAsync(uri);
        Function kindFunction = __ -> {
            SubunitKind result = SubunitKind.NONE;
            if (!((Set)Futures.getUnchecked((Future)parents)).isEmpty()) {
                result = (Boolean)Futures.getUnchecked((Future)isShard) != false ? SubunitKind.SHARD : SubunitKind.SUBMODEL;
            }
            return result;
        };
        ListenableFuture combined = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{parents, isShard});
        return Futures.transform((ListenableFuture)combined, (Function)kindFunction);
    }

    private Runnable postUpdate(final Object element) {
        return new Runnable(){

            @Override
            public void run() {
                ControlledUnitLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ControlledUnitLabelDecorator.this, element));
            }
        };
    }

    private static enum SubunitKind {
        NONE,
        SUBMODEL,
        SHARD;


        ImageDescriptor getIcon() {
            ImageDescriptor result;
            switch (this) {
                case SHARD: {
                    result = ControlModePlugin.getDefault().getIcon("full/ovr16/shard_deco.png");
                    break;
                }
                case SUBMODEL: {
                    result = ControlModePlugin.getDefault().getIcon("full/ovr16/submodel_deco.png");
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }

        static SubunitKind max(Collection<SubunitKind> kinds) {
            return kinds.isEmpty() ? NONE : Collections.max(kinds);
        }
    }
}

