/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.advice;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.UmlSequenceDiagramForMultiEditor;
import org.eclipse.papyrus.uml.diagram.sequence.command.AsynchronousCommand;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.InteractionOperand;

public class DefaultInteractionOperandAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        AsynchronousCommand result = null;
        DiagramEditPart sequenceDiagram = this.getActiveSequenceDiagram();
        if (sequenceDiagram != null) {
            CombinedFragment cfrag = (CombinedFragment)request.getElementToConfigure();
            result = new AsynchronousCommand("Configure Default Operand", request.getEditingDomain(), () -> this.configureOperand(cfrag, sequenceDiagram));
        }
        return result;
    }

    protected DiagramEditPart getActiveSequenceDiagram() {
        DiagramEditPart result = null;
        IEditorPart editor = EditorHelper.getCurrentEditor();
        if (editor instanceof IMultiDiagramEditor) {
            editor = ((IMultiDiagramEditor)editor).getActiveEditor();
        }
        if (editor instanceof UmlSequenceDiagramForMultiEditor) {
            result = ((UmlSequenceDiagramForMultiEditor)editor).getDiagramEditPart();
        }
        return result;
    }

    protected ICommand configureOperand(CombinedFragment cfrag, DiagramEditPart diagram) {
        if (cfrag.getOperands().size() != 1) {
            return null;
        }
        InteractionOperand operand = (InteractionOperand)cfrag.getOperands().get(0);
        IGraphicalEditPart cfragShape = DiagramEditPartsUtil.getChildByEObject((EObject)cfrag, (IGraphicalEditPart)diagram, (boolean)false);
        if (cfragShape == null) {
            return null;
        }
        IGraphicalEditPart operandShape = DiagramEditPartsUtil.getChildByEObject((EObject)operand, (IGraphicalEditPart)cfragShape, (boolean)false);
        if (operandShape == null) {
            return null;
        }
        return this.fill(operandShape, cfragShape);
    }

    protected ICommand fill(IGraphicalEditPart operand, IGraphicalEditPart cfrag) {
        Rectangle cfragBounds = cfrag.getFigure().getBounds();
        Rectangle operandBounds = operand.getFigure().getBounds();
        if (cfragBounds.height() <= 0 || operandBounds.height() <= 0) {
            return null;
        }
        int operandHeight = cfragBounds.y() + cfragBounds.height() - operandBounds.y() - 1;
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize");
        request.setSizeDelta(new Dimension(0, operandHeight - operandBounds.height()));
        request.setResizeDirection(4);
        request.setSnapToEnabled(false);
        request.setEditParts((EditPart)operand);
        Command command = operand.getCommand((Request)request);
        return command == null ? null : new CommandProxy(command);
    }
}

