/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.tools;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.papyrus.uml.diagram.sequence.requests.MoveSeparatorRequest;

public class SeparatorResizeTracker
extends ResizeTracker {
    private int separatorIndex;
    private List<GraphicalEditPart> ownerChildren;

    public SeparatorResizeTracker(GraphicalEditPart owner, int direction, int separatorIndex) {
        super(owner, direction);
        assert (separatorIndex < this.ownerChildren.size() - 1);
        this.separatorIndex = separatorIndex;
    }

    protected List<EditPart> createOperationSet() {
        return Collections.singletonList(this.getOwner());
    }

    protected void updateSourceRequest() {
        MoveSeparatorRequest request = (MoveSeparatorRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        moveDelta.y += d.height;
        request.setMoveDelta(moveDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        this.enforceConstraintsForResize(request);
    }

    private void enforceConstraintsForResize(MoveSeparatorRequest request) {
    }

    protected Request createSourceRequest() {
        return new MoveSeparatorRequest(this.separatorIndex);
    }
}

