/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.databinding;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StringToDateConverter
extends Converter
implements IValidator {
    private List<DateFormat> formats = new ArrayList<DateFormat>();
    private String message;

    public StringToDateConverter(String message) {
        super(String.class, Date.class);
        this.message = message;
        this.formats.add(DateFormat.getDateInstance(3));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd"));
    }

    public Object convert(Object fromObject) {
        if (fromObject == null || fromObject.toString().trim().length() == 0) {
            return null;
        }
        for (DateFormat f : this.formats) {
            try {
                return f.parse(fromObject.toString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new RuntimeException(this.message);
    }

    public IStatus validate(Object value) {
        try {
            this.convert(value);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.emf.examples.databinding.project.ui.rcp", this.message);
        }
        return Status.OK_STATUS;
    }
}

