/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.EvaluationMonitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.IQVTiEvaluationEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTiPivotEvaluator
implements EvaluationMonitor {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final Transformation transformation;
    @NonNull
    protected final QVTiEnvironmentFactory envFactory;
    @NonNull
    protected final QVTiEnvironment env;
    @NonNull
    protected final QVTiModelManager modelManager;
    private EvaluationMonitor monitor = null;
    private boolean canceled = false;

    public QVTiPivotEvaluator(@NonNull QVTiEnvironmentFactory envFactory, @NonNull Transformation transformation) {
        this.envFactory = envFactory;
        this.metaModelManager = envFactory.getMetaModelManager();
        this.transformation = transformation;
        this.env = envFactory.createEnvironment();
        QVTiTransformationAnalysis transformationAnalysis = envFactory.createTransformationAnalysis();
        transformationAnalysis.analyzeTransformation(transformation);
        this.modelManager = envFactory.createModelManager(transformationAnalysis);
    }

    public QVTiPivotEvaluator(@NonNull MetaModelManager metaModelManager, @NonNull Transformation transformation) {
        this.metaModelManager = metaModelManager;
        this.transformation = transformation;
        this.envFactory = new QVTiEnvironmentFactory(null, metaModelManager);
        this.env = this.envFactory.createEnvironment();
        QVTiTransformationAnalysis transformationAnalysis = this.envFactory.createTransformationAnalysis();
        transformationAnalysis.analyzeTransformation(transformation);
        this.modelManager = this.envFactory.createModelManager(transformationAnalysis);
    }

    public void addModel(@NonNull TypedModel typedModel, @NonNull Resource resource) {
        this.modelManager.addModel(typedModel, resource);
    }

    @Override
    public void cancel() {
        if (this.monitor != null) {
            this.monitor.cancel();
        } else {
            this.canceled = true;
        }
    }

    @Deprecated
    public void createModel(@NonNull String name, @NonNull URI modelURI) {
        this.createModel(name, modelURI, null);
    }

    public void createModel(@NonNull String name, @NonNull URI modelURI, String contentType) {
        TypedModel typedModel = (TypedModel)DomainUtil.getNamedElement((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.metaModelManager.getExternalResourceSet().createResource(modelURI, contentType);
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void dispose() {
        this.modelManager.dispose();
    }

    public Boolean execute() {
        IQVTiEvaluationEnvironment evalEnv = this.envFactory.createEvaluationEnvironment(this.modelManager, this.transformation);
        QVTiEvaluationVisitor visitor = this.envFactory.createEvaluationVisitor(this.env, evalEnv);
        return (Boolean)this.transformation.accept((Visitor)visitor);
    }

    @NonNull
    public EvaluationMonitor getEvaluationMonitor() {
        return this.monitor != null ? this.monitor : this;
    }

    @NonNull
    public final QVTiEnvironment getEnvironment() {
        return this.env;
    }

    @NonNull
    public final QVTiEnvironmentFactory getEnvironmentFactory() {
        return this.envFactory;
    }

    @NonNull
    public final MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @NonNull
    public final QVTiModelManager getModelManager() {
        return this.modelManager;
    }

    @NonNull
    public final Transformation getTransformation() {
        return this.transformation;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled || this.monitor != null && this.monitor.isCanceled();
    }

    public void loadModel(@NonNull String name, @NonNull URI modelURI) {
        TypedModel typedModel = (TypedModel)DomainUtil.getNamedElement((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.metaModelManager.getExternalResourceSet().getResource(modelURI, true);
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void loadModel(@NonNull String name, @NonNull URI modelURI, String contentType) {
        Resource resource;
        TypedModel typedModel = (TypedModel)DomainUtil.getNamedElement((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        if (contentType == null) {
            resource = this.metaModelManager.getExternalResourceSet().getResource(modelURI, true);
        } else {
            resource = this.metaModelManager.getExternalResourceSet().createResource(modelURI, contentType);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (resource != null) {
            this.modelManager.addModel(typedModel, resource);
        }
    }

    public void saveModels() {
        this.modelManager.saveModels();
    }

    public void saveModels(@NonNull URI traceURI) {
        this.saveModels();
        this.modelManager.saveMiddleModel(traceURI);
    }

    public void saveTransformation(Map<?, ?> options) throws IOException {
        XMLResource resource = (XMLResource)this.transformation.eResource();
        resource.save(options);
    }

    public void setEvaluationMonitor(@Nullable EvaluationMonitor monitor) {
        this.monitor = monitor;
    }
}

