/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ComposedNode;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class LoadingRegionAnalysis
extends RegionHelper<LoadingRegion> {
    private Node nullNode = null;
    private final @NonNull Map<@NonNull ClassDatum, @NonNull Map<@Nullable Property, @NonNull Node>> classDatum2property2node = new HashMap<ClassDatum, Map<Property, Node>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull Map<@Nullable ClassDatum, @NonNull Node>> classDatum2type2node = new HashMap<ClassDatum, Map<ClassDatum, Node>>();

    public LoadingRegionAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull LoadingRegion loadingRegion) {
        super(scheduleManager, loadingRegion);
    }

    public @NonNull Node createComposingNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        Role nodeRole = Role.LOADED;
        ComposedNode node = QVTscheduleFactory.eINSTANCE.createComposedNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        return node;
    }

    public @NonNull Node getIntroducerNode(@NonNull Node consumerNode) {
        Node introducedNode;
        NavigableEdge containerEdge = null;
        Property parent2childProperty = null;
        ClassDatum containingClassDatum = null;
        for (NavigableEdge edge : consumerNode.getNavigableEdges()) {
            Property property = edge.getProperty().getOpposite();
            if (property == null || !property.isIsComposite() || property.isIsRequired()) continue;
            containerEdge = edge;
            parent2childProperty = property;
            if (property != this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty()) break;
            containingClassDatum = QVTscheduleUtil.getClassDatum((Node)edge.getEdgeSource());
            break;
        }
        CompleteEnvironment completeEnvironment = this.scheduleManager.getEnvironmentFactory().getCompleteEnvironment();
        ClassDatum consumedClassDatum = QVTscheduleUtil.getClassDatum((Node)consumerNode);
        Class elementType = consumedClassDatum.getCompleteClass().getPrimaryClass();
        TypedModel typedModel = QVTscheduleUtil.getTypedModel((ClassDatum)consumedClassDatum);
        CollectionType childCollectionType = completeEnvironment.getSetType((Type)elementType, true, null, null);
        ClassDatum childrenClassDatum = this.scheduleManager.getClassDatum(typedModel, (Class)childCollectionType);
        if (parent2childProperty == null) {
            Map<@Nullable ClassDatum, @NonNull Node> type2node = this.classDatum2type2node.get(consumedClassDatum);
            if (type2node == null) {
                type2node = new HashMap<ClassDatum, Node>();
                this.classDatum2type2node.put(consumedClassDatum, type2node);
            }
            if ((introducedNode = type2node.get(null)) == null) {
                introducedNode = this.createComposingNode("\u00ab" + elementType.getName() + "\u00bb", childrenClassDatum);
                type2node.put(null, introducedNode);
            }
        } else if (containerEdge != null && containerEdge.getEdgeTarget().isNullLiteral()) {
            Map<@Nullable Property, @NonNull Node> property2node = this.classDatum2property2node.get(consumedClassDatum);
            if (property2node == null) {
                property2node = new HashMap<Property, Node>();
                this.classDatum2property2node.put(consumedClassDatum, property2node);
            }
            if ((introducedNode = property2node.get(null)) == null) {
                introducedNode = this.createComposingNode("\u00ab" + elementType.getName() + "-null\u00bb", childrenClassDatum);
                property2node.put(null, introducedNode);
                this.createNavigationEdge(this.getNullNode(), parent2childProperty, introducedNode, false);
            }
        } else if (containingClassDatum != null) {
            Map<@Nullable ClassDatum, @NonNull Node> type2node = this.classDatum2type2node.get(consumedClassDatum);
            if (type2node == null) {
                type2node = new HashMap<ClassDatum, Node>();
                this.classDatum2type2node.put(consumedClassDatum, type2node);
            }
            if ((introducedNode = type2node.get(containingClassDatum)) == null) {
                introducedNode = this.createComposingNode("\u00ab" + elementType.getName() + "-oclContents\u00bb", childrenClassDatum);
                type2node.put(containingClassDatum, introducedNode);
                Node containerNode = this.createComposingNode("\u00ab" + containingClassDatum.getCompleteClass().getName() + "-oclContainer\u00bb", containingClassDatum);
                this.createNavigationEdge(containerNode, parent2childProperty, introducedNode, false);
            }
        } else {
            Map<@Nullable Property, @NonNull Node> property2node = this.classDatum2property2node.get(consumedClassDatum);
            if (property2node == null) {
                property2node = new HashMap<Property, Node>();
                this.classDatum2property2node.put(consumedClassDatum, property2node);
            }
            if ((introducedNode = property2node.get(parent2childProperty)) == null) {
                introducedNode = this.createComposingNode("\u00ab" + elementType.getName() + "-" + parent2childProperty.getName() + "\u00bb", childrenClassDatum);
                property2node.put(parent2childProperty, introducedNode);
                Class owningClass = parent2childProperty.getOwningClass();
                assert (owningClass != null);
                containingClassDatum = this.scheduleManager.getClassDatum(typedModel, owningClass);
                Node containerNode = this.createComposingNode("\u00ab" + owningClass.getName() + "-" + parent2childProperty.getName() + "\u00bb", containingClassDatum);
                this.createNavigationEdge(containerNode, parent2childProperty, introducedNode, false);
            }
        }
        return introducedNode;
    }

    protected @NonNull Node getNullNode() {
        Node nullNode2 = this.nullNode;
        if (nullNode2 == null) {
            this.nullNode = nullNode2 = this.createNullLiteralNode(true, null);
        }
        return nullNode2;
    }
}

