/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.QVTcCompilerChain;
import org.eclipse.qvtd.debug.launching.QVTcLaunchConfigurationDelegate;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.launching.QVTDirectionalMainTab;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.swt.graphics.Image;

public class QVTcMainTab
extends QVTDirectionalMainTab<Transformation> {
    protected @NonNull QVTcCompilerChain createCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull CompilerOptions options) {
        return new QVTcCompilerChain(environmentFactory, txURI, txURI, options);
    }

    @Override
    public Image getImage() {
        return QVTdDebugUIPlugin.getDefault().createImage("icons/QVTcModelFile.gif");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull List<@NonNull String> getIntermediateKeys() {
        @NonNull ArrayList asList = Lists.newArrayList((Object[])QVTcLaunchConfigurationDelegate.compileStepKeys);
        if (!this.isInterpreted()) {
            String[] stringArray = QVTcLaunchConfigurationDelegate.generateStepKeys;
            int n = QVTcLaunchConfigurationDelegate.generateStepKeys.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String stepKey = stringArray[n2];
                asList.add(stepKey);
                ++n2;
            }
        }
        return asList;
    }

    @Override
    protected void initializeOptions(@NonNull DefaultCompilerOptions compilerOptions) throws IOException {
        Map<@NonNull String, @NonNull URI> intermediatesMap = this.getIntermediatesMap(QVTcLaunchConfigurationDelegate.compileStepKeys);
        compilerOptions.setURIs2(QVTcLaunchConfigurationDelegate.compileStepKeys, intermediatesMap);
        compilerOptions.setDebugGraphs(this.doDotGraphs(), this.doYedGraphs());
        if (!this.isInterpreted()) {
            URI txURI = this.getTxURI();
            URI genModelURI = this.getResolvedGenModel();
            URI javaURI = this.getResolvedCompilerStep("Java");
            URI classURI = this.getResolvedCompilerStep("Class");
            compilerOptions.setQVTcGenerateOptions(this.getProjectName(), txURI, genModelURI, javaURI, classURI);
        }
    }

    @Override
    protected @NonNull Transformation updateTransformation(@NonNull URI txURI) throws IOException {
        QVTiEnvironmentFactory environmentFactory = this.getEnvironmentFactory();
        return QVTcoreUtil.loadTransformation((QVTbaseEnvironmentFactory)environmentFactory, (URI)txURI, (boolean)environmentFactory.keepDebug());
    }
}

