/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.IQVTColors;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTColorManager;

class CommentScanner
extends BufferedRuleBasedScanner {
    public CommentScanner(QVTColorManager manager, String colorId) {
        Token keyWord = manager.getColor(IQVTColors.TASK_TAG).createToken();
        Token defaultToken = manager.getColor(colorId).createToken();
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new DefaultKeywordDetector(), (IToken)defaultToken);
        this.addKeywords(wordRule, (IToken)keyWord);
        rules.add(wordRule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)defaultToken);
    }

    private void addKeywords(WordRule wordRule, IToken keyWord) {
        wordRule.addWord("TODO", keyWord);
        wordRule.addWord("FIXME", keyWord);
    }

    private static class DefaultKeywordDetector
    implements IWordDetector {
        private DefaultKeywordDetector() {
        }

        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character);
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierStart(character);
        }
    }

    private static class WhitespaceDetector
    implements IWhitespaceDetector {
        private WhitespaceDetector() {
        }

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }
}

