/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.labeling;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EOF;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.ui.label.StylerFactory;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.ui.editor.syntaxcoloring.SemanticHighlightingConfiguration;

public class XtextLabelProvider
extends DefaultEObjectLabelProvider {
    private static final String UNKNOWN = "<unknown>";
    @Inject
    private SemanticHighlightingConfiguration semanticHighlightingConfiguration;
    @Inject
    private StylerFactory stylerFactory;

    @Inject
    public XtextLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    StyledString text(ParserRule parserRule) {
        if (GrammarUtil.isDatatypeRule((ParserRule)parserRule)) {
            StyledString.Styler xtextStyleAdapterStyler = this.stylerFactory.createXtextStyleAdapterStyler(this.semanticHighlightingConfiguration.dataTypeRule());
            return new StyledString(parserRule.getName(), xtextStyleAdapterStyler);
        }
        return this.convertToStyledString(parserRule.getName());
    }

    StyledString text(EnumLiteralDeclaration object) {
        String literalName = this.getLiteralName(object);
        Keyword kw = object.getLiteral();
        String kwValue = kw == null ? "" : " = '" + kw.getValue() + "'";
        return new StyledString(literalName + kwValue, UNKNOWN.equalsIgnoreCase(literalName) ? this.stylerFactory.createStyler("ERROR_COLOR", null) : null);
    }

    String text(Grammar object) {
        return "grammar " + GrammarUtil.getLanguageId((Grammar)object);
    }

    String text(GeneratedMetamodel object) {
        return "generate " + object.getName() + (String)(!Strings.isEmpty((String)object.getAlias()) ? " as " + object.getAlias() : "");
    }

    String text(ReferencedMetamodel object) {
        Object label = "";
        if (object.getAlias() != null) {
            label = " " + object.getAlias();
        }
        if (object.getEPackage() != null) {
            label = ((String)label).length() == 0 ? " " + object.getEPackage().getName() : " " + object.getEPackage().getName() + " as" + (String)label;
        }
        if (((String)label).length() == 0) {
            label = " <unknown>";
        }
        return "import" + (String)label;
    }

    String text(Assignment object) {
        StringBuffer label = new StringBuffer();
        label.append(object.getFeature()).append(" ").append(object.getOperator()).append(" ");
        AbstractElement terminal = object.getTerminal();
        if (terminal instanceof RuleCall) {
            RuleCall ruleCall = (RuleCall)terminal;
            String string = NodeModelUtils.getNode((EObject)ruleCall).getText();
            label.append(string);
        } else if (terminal instanceof Keyword) {
            Keyword keyword = (Keyword)terminal;
            String value = "'" + keyword.getValue() + "'";
            label.append(value);
        } else if (terminal instanceof CrossReference) {
            CrossReference crossReference = (CrossReference)terminal;
            label.append(this.getLabel(crossReference));
        } else {
            label.append("(..)");
        }
        String cardinality = object.getCardinality();
        label.append(cardinality != null ? cardinality : "");
        return label.toString();
    }

    String text(CrossReference object) {
        return this.getLabel(object);
    }

    String text(AbstractRule object) {
        return object.getName();
    }

    String text(Action object) {
        String classifierName = this.getClassifierName(object.getType());
        return "{" + classifierName + (String)(object.getFeature() != null ? "." + object.getFeature() : "") + "}";
    }

    String text(Alternatives object) {
        return "|";
    }

    String text(UnorderedGroup object) {
        return "&";
    }

    String text(CharacterRange object) {
        return object.getLeft().getValue() + " .. " + object.getRight().getValue();
    }

    String text(NegatedToken object) {
        return "!";
    }

    String text(UntilToken object) {
        return "->";
    }

    String text(Wildcard object) {
        return "*";
    }

    String text(EOF object) {
        return "EOF";
    }

    String text(Keyword object) {
        return "'" + object.getValue() + "'";
    }

    String text(TypeRef object) {
        return "'" + String.valueOf(object) + "'";
    }

    private String getLiteralName(EnumLiteralDeclaration declaration) {
        if (declaration.getEnumLiteral() != null) {
            return declaration.getEnumLiteral().getName();
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)declaration);
        String literalName = UNKNOWN;
        if (node != null) {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                literalName = leaf.getText();
                break;
            }
        }
        return literalName;
    }

    private String getLabel(RuleCall ruleCall) {
        if (ruleCall.getRule() != null) {
            return ruleCall.getRule().getName();
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)ruleCall);
        String ruleName = UNKNOWN;
        if (node != null) {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                ruleName = leaf.getText();
                break;
            }
        }
        return ruleName;
    }

    private String getLabel(CrossReference ref) {
        TypeRef type = ref.getType();
        String typeName = this.getClassifierName(type);
        if (ref.getTerminal() instanceof RuleCall) {
            return "[" + typeName + "|" + this.getLabel((RuleCall)ref.getTerminal()) + "]";
        }
        return "[" + typeName + "|..]";
    }

    private String getClassifierName(TypeRef ref) {
        String classifierName = UNKNOWN;
        if (ref != null) {
            if (ref.getClassifier() != null) {
                classifierName = ref.getClassifier().getName();
            } else {
                ICompositeNode node = NodeModelUtils.getNode((EObject)ref);
                if (node != null) {
                    ArrayList leafs = Lists.newArrayList((Iterable)node.getLeafNodes());
                    int i = leafs.size() - 1;
                    while (i >= 0) {
                        if (!((ILeafNode)leafs.get(i)).isHidden()) {
                            classifierName = ((ILeafNode)leafs.get(i)).getText();
                            break;
                        }
                        --i;
                    }
                }
            }
        }
        return classifierName;
    }

    String image(Grammar grammar) {
        return "language.gif";
    }

    String image(GeneratedMetamodel metamodel) {
        return "export.gif";
    }

    String image(ReferencedMetamodel metamodel) {
        return "import.gif";
    }

    String image(AbstractRule rule) {
        return "rule.gif";
    }

    String image(RuleCall ruleCall) {
        return "rule.gif";
    }

    String image(Keyword keyword) {
        return "keyword.gif";
    }
}

