/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist.antlr;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.xtext.ConditionEvaluator;
import org.eclipse.xtext.xtext.ParameterConfigHelper;
import org.eclipse.xtext.xtext.RuleNames;

@Singleton
public class RequiredRuleNameComputer {
    private static final String[][] EMPTY_ARRAY = new String[0][];
    @Inject
    private RuleNames ruleNames;

    public String[][] getRequiredRuleNames(Param param) {
        List<AbstractElement> tokens;
        int idx;
        if (this.isFiltered(param)) {
            return EMPTY_ARRAY;
        }
        AbstractElement elementToParse = param.elementToParse;
        String ruleName = param.ruleName;
        if (ruleName == null) {
            RuleCall call;
            if (elementToParse instanceof RuleCall && (call = (RuleCall)elementToParse).getRule() instanceof ParserRule) {
                String antlrRuleName = this.ruleNames.getAntlrRuleName(call.getRule());
                if (!call.getArguments().isEmpty()) {
                    Set<Parameter> context = param.getAssignedParametes();
                    Set arguments = ParameterConfigHelper.getAssignedArguments((RuleCall)call, context);
                    int config = ParameterConfigHelper.getParameterConfig((Set)arguments);
                    antlrRuleName = this.ruleNames.getAntlrRuleName(call.getRule(), config);
                }
                return new String[][]{{antlrRuleName}};
            }
            return EMPTY_ARRAY;
        }
        String adjustedRuleName = this.adjustRuleName(ruleName, param);
        if (!GrammarUtil.isOptionalCardinality((AbstractElement)elementToParse) && !GrammarUtil.isOneOrMoreCardinality((AbstractElement)elementToParse)) {
            return new String[][]{{adjustedRuleName}};
        }
        if (elementToParse.eContainer() instanceof Group && (idx = (tokens = this.getFilteredElements((List<AbstractElement>)((Group)elementToParse.eContainer()).getElements(), param)).indexOf(elementToParse) + 1) != tokens.size()) {
            String secondRule = param.getBaseRuleName((AbstractElement)elementToParse.eContainer());
            secondRule = String.valueOf(secondRule.substring(0, secondRule.lastIndexOf(95) + 1)) + idx;
            String adjustedSecondRule = this.adjustRuleName(secondRule, param);
            if (GrammarUtil.isMultipleCardinality((AbstractElement)elementToParse)) {
                return new String[][]{{adjustedRuleName}, {adjustedRuleName, adjustedSecondRule}};
            }
            return new String[][]{{adjustedRuleName, adjustedSecondRule}};
        }
        return new String[][]{{ruleName}};
    }

    protected List<AbstractElement> getFilteredElements(List<AbstractElement> elements, Param param) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)elements.size());
        for (AbstractElement element : elements) {
            if (this.isFiltered(element, param)) continue;
            result.add(element);
        }
        return result;
    }

    protected boolean isFiltered(Param param) {
        return this.isFiltered(param.elementToParse, param);
    }

    protected boolean isFiltered(AbstractElement canddiate, Param param) {
        Set<Parameter> context;
        ConditionEvaluator evaluator;
        Group group;
        return canddiate instanceof Group && (group = (Group)canddiate).getGuardCondition() != null && !(evaluator = new ConditionEvaluator(context = param.getAssignedParametes())).evaluate(group.getGuardCondition());
    }

    protected String adjustRuleName(String ruleName, Param param) {
        AbstractElement elementToParse = param.elementToParse;
        Set context = ParameterConfigHelper.getAssignedParameters((AbstractElement)elementToParse, param.paramStack);
        if (!context.isEmpty()) {
            ParserRule containingRule = GrammarUtil.containingParserRule((EObject)elementToParse);
            String antlrRuleName = this.ruleNames.getAntlrRuleName((AbstractRule)containingRule);
            int len = antlrRuleName.length();
            if (antlrRuleName.startsWith("rule")) {
                len += 2;
            }
            int config = ParameterConfigHelper.getParameterConfig((Set)context);
            String result = String.valueOf(this.ruleNames.getAntlrRuleName((AbstractRule)containingRule, config)) + ruleName.substring(len);
            return result;
        }
        return ruleName;
    }

    protected RuleNames getRuleNames() {
        return this.ruleNames;
    }

    public static abstract class Param {
        public String ruleName;
        public List<Integer> paramStack;
        public AbstractElement elementToParse;
        private Set<Parameter> assignedParameters;

        protected Param(String ruleName, List<Integer> paramStack, AbstractElement elementToParse) {
            this.ruleName = ruleName;
            this.paramStack = paramStack;
            this.elementToParse = elementToParse;
        }

        public Set<Parameter> getAssignedParametes() {
            if (this.assignedParameters == null) {
                this.assignedParameters = ParameterConfigHelper.getAssignedParameters((AbstractElement)this.elementToParse, this.paramStack);
                return this.assignedParameters;
            }
            return this.assignedParameters;
        }

        public abstract String getBaseRuleName(AbstractElement var1);
    }
}

