/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.common.base.Objects;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class ASTParserFactory {
    protected final String minParserApiLevel = "1.6";

    protected final ASTParser createDefaultJavaParser(String javaVersion) {
        ASTParser parser = null;
        Hashtable options = JavaCore.getOptions();
        try {
            ASTParser _newParser;
            int _asJLS = ASTParserFactory.asJLS(javaVersion);
            parser = _newParser = ASTParser.newParser((int)_asJLS);
            JavaCore.setComplianceOptions((String)javaVersion, (Map)options);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                ASTParser _newParser_1;
                IllegalArgumentException e = (IllegalArgumentException)_t;
                int _asJLS_1 = ASTParserFactory.asJLS("1.6");
                parser = _newParser_1 = ASTParser.newParser((int)_asJLS_1);
                JavaCore.setComplianceOptions((String)"1.6", (Map)options);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions((Map)options);
        parser.setStatementsRecovery(true);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        return parser;
    }

    public static int asJLS(String javaVersion) {
        int _switchResult = 0;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)javaVersion, (Object)"1.7")) {
            _matched = true;
            _switchResult = 4;
        }
        if (!_matched && Objects.equal((Object)javaVersion, (Object)"1.8")) {
            _matched = true;
            _switchResult = 8;
        }
        if (!_matched) {
            _switchResult = 3;
        }
        return _switchResult;
    }

    public ASTParserWrapper createJavaParser(Object context) {
        String targetJavaVersion = System.getProperty("java.specification.version");
        if (targetJavaVersion == null) {
            targetJavaVersion = "1.6";
        }
        ASTParser parser = this.createDefaultJavaParser(targetJavaVersion);
        this.provideCustomEnvironment(parser);
        return new ASTParserWrapper(targetJavaVersion, parser);
    }

    protected void provideCustomEnvironment(ASTParser parser) {
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        URL[] _uRLs = ((URLClassLoader)sysClassLoader).getURLs();
        Functions.Function1<URL, String> _function = new Functions.Function1<URL, String>(){

            public String apply(URL it) {
                return it.getFile();
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_uRLs)), (Functions.Function1)_function);
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                File _file = new File(it);
                return _file.exists();
            }
        };
        Iterable cpEntries = IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
        parser.setEnvironment((String[])Conversions.unwrapArray((Object)cpEntries, String.class), null, null, true);
    }

    @Data
    public static class ASTParserWrapper {
        private final String targetLevel;
        private final ASTParser parser;

        public ASTNode createAST() {
            return this.parser.createAST(null);
        }

        public void setKind(int i) {
            this.parser.setKind(i);
        }

        public void setSource(char[] cs) {
            this.parser.setSource(cs);
        }

        public void setUnitName(String string) {
            this.parser.setUnitName(string);
        }

        public ASTParserWrapper(String targetLevel, ASTParser parser) {
            this.targetLevel = targetLevel;
            this.parser = parser;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.targetLevel == null ? 0 : this.targetLevel.hashCode());
            result = 31 * result + (this.parser == null ? 0 : this.parser.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ASTParserWrapper other = (ASTParserWrapper)obj;
            if (this.targetLevel == null ? other.targetLevel != null : !this.targetLevel.equals(other.targetLevel)) {
                return false;
            }
            return !(this.parser == null ? other.parser != null : !this.parser.equals(other.parser));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("targetLevel", (Object)this.targetLevel);
            b.add("parser", (Object)this.parser);
            return b.toString();
        }

        @Pure
        public String getTargetLevel() {
            return this.targetLevel;
        }

        @Pure
        public ASTParser getParser() {
            return this.parser;
        }
    }
}

