/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.labeling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtend.ide.labeling.XtendJvmLabelProvider;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XtendLabelProvider
extends XtendJvmLabelProvider {
    @Inject
    private UIStrings uiStrings;
    @Inject
    private XtendImages images;
    @Inject
    @Extension
    private IXtendJvmAssociations _iXtendJvmAssociations;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    @Extension
    private DispatchHelper _dispatchHelper;
    @Inject
    private OperatorMapping operatorMapping;

    @Inject
    public XtendLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected ImageDescriptor _imageDescriptor(XtendFile element) {
        return this.images.forFile();
    }

    protected ImageDescriptor _imageDescriptor(XtendClass element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmGenericType _inferredType = this._iXtendJvmAssociations.getInferredType(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType);
        return this.images.forClass(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(XtendInterface element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmGenericType _inferredType = this._iXtendJvmAssociations.getInferredType(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType);
        return this.images.forInterface(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(XtendEnum element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmDeclaredType _inferredType = this._iXtendJvmAssociations.getInferredType((XtendTypeDeclaration)element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType);
        return this.images.forEnum(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(XtendAnnotationType element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmDeclaredType _inferredType = this._iXtendJvmAssociations.getInferredType((XtendTypeDeclaration)element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType);
        return this.images.forAnnotation(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(XtendFunction element) {
        boolean _notEquals;
        ImageDescriptor _xblockexpression = null;
        JvmOperation operation = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
        ImageDescriptor _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)operation, null);
        if (_notEquals) {
            JvmVisibility _visibility = element.getVisibility();
            int _get = this.adornments.get((JvmIdentifiableElement)operation);
            _xifexpression = this.images.forOperation(_visibility, _get);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ImageDescriptor _imageDescriptor(AnonymousClass element) {
        JvmGenericType _inferredType = this._iXtendJvmAssociations.getInferredType(element);
        JvmVisibility _visibility = _inferredType.getVisibility();
        JvmGenericType _inferredType_1 = this._iXtendJvmAssociations.getInferredType(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredType_1);
        return this.images.forClass(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(JvmOperation operation) {
        ImageDescriptor _xifexpression = null;
        boolean _isDispatcherFunction = this._dispatchHelper.isDispatcherFunction(operation);
        if (_isDispatcherFunction) {
            JvmVisibility _visibility = operation.getVisibility();
            int _get = this.adornments.get((JvmIdentifiableElement)operation);
            _xifexpression = this.images.forDispatcherFunction(_visibility, _get);
        } else {
            JvmVisibility _visibility_1 = operation.getVisibility();
            int _get_1 = this.adornments.get((JvmIdentifiableElement)operation);
            _xifexpression = this.images.forOperation(_visibility_1, _get_1);
        }
        return _xifexpression;
    }

    protected ImageDescriptor _imageDescriptor(XtendConstructor element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmConstructor _inferredConstructor = this._iXtendJvmAssociations.getInferredConstructor(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_inferredConstructor);
        return this.images.forConstructor(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(XtendField element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmField _jvmField = this._iXtendJvmAssociations.getJvmField(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_jvmField);
        return this.images.forField(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(XtendEnumLiteral element) {
        JvmVisibility _visibility = element.getVisibility();
        JvmField _jvmField = this._iXtendJvmAssociations.getJvmField(element);
        int _get = this.adornments.get((JvmIdentifiableElement)_jvmField);
        return this.images.forField(_visibility, _get);
    }

    protected String text(XtendFile element) {
        Resource _eResource = element.eResource();
        URI _uRI = _eResource.getURI();
        URI _trimFileExtension = _uRI.trimFileExtension();
        return _trimFileExtension.lastSegment();
    }

    protected String text(XtendClass element) {
        String _name = element.getName();
        String _xifexpression = null;
        EList _typeParameters = element.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            EList _typeParameters_1 = element.getTypeParameters();
            _xifexpression = this.uiStrings.typeParameters((Iterable)_typeParameters_1);
        }
        return String.valueOf(_name) + _xifexpression;
    }

    protected String text(XtendInterface element) {
        String _name = element.getName();
        String _xifexpression = null;
        EList _typeParameters = element.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            EList _typeParameters_1 = element.getTypeParameters();
            _xifexpression = this.uiStrings.typeParameters((Iterable)_typeParameters_1);
        }
        return String.valueOf(_name) + _xifexpression;
    }

    protected String text(AnonymousClass element) {
        JvmGenericType _inferredType = this._iXtendJvmAssociations.getInferredType(element);
        return this.text(_inferredType);
    }

    protected String text(XtendConstructor element) {
        JvmConstructor _inferredConstructor = this._iXtendJvmAssociations.getInferredConstructor(element);
        String _parameters = this.uiStrings.parameters((JvmIdentifiableElement)_inferredConstructor);
        return "new" + _parameters;
    }

    protected StyledString text(XtendFunction element) {
        boolean _notEquals;
        String simpleName = element.getName();
        boolean bl = _notEquals = !Objects.equal((Object)simpleName, null);
        if (_notEquals) {
            boolean _notEquals_1;
            QualifiedName qnName = QualifiedName.create((String)simpleName);
            QualifiedName operator = this.operatorMapping.getOperator(qnName);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)operator, null);
            if (_notEquals_1) {
                String _firstSegment = operator.getFirstSegment();
                JvmOperation _directlyInferredOperation = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
                StyledString result = this.signature(_firstSegment, (JvmIdentifiableElement)_directlyInferredOperation);
                result.append(" (" + simpleName + ")", StyledString.COUNTER_STYLER);
                return result;
            }
        }
        String _name = element.getName();
        JvmOperation _directlyInferredOperation_1 = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
        return this.signature(_name, (JvmIdentifiableElement)_directlyInferredOperation_1);
    }

    protected StyledString text(XtendField element) {
        boolean _notEquals;
        boolean _isExtension;
        StyledString _xblockexpression = null;
        boolean _and = false;
        String _name = element.getName();
        boolean _equals = Objects.equal((Object)_name, null);
        _and = !_equals ? false : (_isExtension = element.isExtension());
        if (_and) {
            JvmTypeReference _type = element.getType();
            String _referenceToString = this.uiStrings.referenceToString(_type, "extension");
            return new StyledString(_referenceToString, StyledString.DECORATIONS_STYLER);
        }
        JvmTypeReference fieldType = this.getDisplayedType(element);
        boolean bl = _notEquals = !Objects.equal((Object)fieldType, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String type = this.uiStrings.referenceToString(fieldType, "");
            int _length = type.length();
            boolean bl2 = _notEquals_1 = _length != 0;
            if (_notEquals_1) {
                String _name_1 = element.getName();
                StyledString _styledString = new StyledString(_name_1);
                StyledString _styledString_1 = new StyledString(" : " + type, StyledString.DECORATIONS_STYLER);
                return _styledString.append(_styledString_1);
            }
        }
        String _name_2 = element.getName();
        _xblockexpression = new StyledString(_name_2);
        return _xblockexpression;
    }

    protected String text(XtendEnumLiteral element) {
        return element.getName();
    }

    protected String text(XtendParameter element) {
        JvmTypeReference _parameterType = element.getParameterType();
        String _simpleName = _parameterType.getSimpleName();
        String _plus = String.valueOf(_simpleName) + " ";
        String _name = element.getName();
        return String.valueOf(_plus) + _name;
    }

    protected JvmTypeReference getDisplayedType(XtendField field) {
        EObject next;
        boolean _notEquals;
        Object _xblockexpression = null;
        JvmField jvmField = this._iXtendJvmAssociations.getJvmField(field);
        boolean bl = _notEquals = !Objects.equal((Object)jvmField, null);
        if (_notEquals) {
            return jvmField.getType();
        }
        Set _jvmElements = this._iXtendJvmAssociations.getJvmElements((EObject)field);
        Iterator i = _jvmElements.iterator();
        boolean _hasNext = i.hasNext();
        if (_hasNext && (next = (EObject)i.next()) instanceof JvmOperation) {
            return ((JvmOperation)next).getReturnType();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected ImageDescriptor imageDescriptor(Object operation) {
        if (operation instanceof JvmConstructor) {
            return this._imageDescriptor((JvmConstructor)operation);
        }
        if (operation instanceof JvmOperation) {
            return this._imageDescriptor((JvmOperation)operation);
        }
        if (operation instanceof JvmAnnotationType) {
            return this._imageDescriptor((JvmAnnotationType)operation);
        }
        if (operation instanceof JvmEnumerationType) {
            return this._imageDescriptor((JvmEnumerationType)operation);
        }
        if (operation instanceof JvmField) {
            return this._imageDescriptor((JvmField)operation);
        }
        if (operation instanceof JvmGenericType) {
            return this._imageDescriptor((JvmGenericType)operation);
        }
        if (operation instanceof AnonymousClass) {
            return this._imageDescriptor((AnonymousClass)operation);
        }
        if (operation instanceof XtendAnnotationType) {
            return this._imageDescriptor((XtendAnnotationType)operation);
        }
        if (operation instanceof XtendClass) {
            return this._imageDescriptor((XtendClass)operation);
        }
        if (operation instanceof XtendConstructor) {
            return this._imageDescriptor((XtendConstructor)operation);
        }
        if (operation instanceof XtendEnum) {
            return this._imageDescriptor((XtendEnum)operation);
        }
        if (operation instanceof XtendFunction) {
            return this._imageDescriptor((XtendFunction)operation);
        }
        if (operation instanceof XtendInterface) {
            return this._imageDescriptor((XtendInterface)operation);
        }
        if (operation instanceof JvmTypeParameter) {
            return this._imageDescriptor((JvmTypeParameter)operation);
        }
        if (operation instanceof XtendEnumLiteral) {
            return this._imageDescriptor((XtendEnumLiteral)operation);
        }
        if (operation instanceof XtendField) {
            return this._imageDescriptor((XtendField)operation);
        }
        if (operation instanceof JvmFormalParameter) {
            return this._imageDescriptor((JvmFormalParameter)operation);
        }
        if (operation instanceof XVariableDeclaration) {
            return this._imageDescriptor((XVariableDeclaration)operation);
        }
        if (operation instanceof XtendFile) {
            return this._imageDescriptor((XtendFile)operation);
        }
        if (operation instanceof IResolvedConstructor) {
            return this._imageDescriptor((IResolvedConstructor)operation);
        }
        if (operation instanceof IResolvedOperation) {
            return this._imageDescriptor((IResolvedOperation)operation);
        }
        if (operation instanceof XImportDeclaration) {
            return this._imageDescriptor((XImportDeclaration)operation);
        }
        if (operation instanceof XImportSection) {
            return this._imageDescriptor((XImportSection)operation);
        }
        if (operation instanceof IResolvedField) {
            return this._imageDescriptor((IResolvedField)operation);
        }
        if (operation != null) {
            return this._imageDescriptor(operation);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(operation).toString());
    }
}

