/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.testing;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Queue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.ResourceAccess;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.ui.jvmmodel.findrefs.JvmModelReferenceQueryExecutor;
import org.junit.Assert;

public class FindReferencesTestUtil
extends Assert {
    @Inject
    private Provider<CheckingReferenceQueryExecutor> executorProvider;

    public void checkFindReferences(EObject target, String expectedLabel, MockAcceptor mockAcceptor) {
        CheckingReferenceQueryExecutor executor = (CheckingReferenceQueryExecutor)((Object)this.executorProvider.get());
        executor.init(target, expectedLabel, mockAcceptor);
        executor.execute();
        mockAcceptor.assertFinished();
    }

    public static class CheckingReferenceQueryExecutor
    extends JvmModelReferenceQueryExecutor {
        @Inject
        private IReferenceFinder referenceFinder;
        @Inject
        private Provider<ResourceAccess> resourceAccessProvider;
        private Iterable<URI> targetURIs;
        private Predicate<IReferenceDescription> filter;
        private ResourceAccess localResourceAccess;
        private IAcceptor<IReferenceDescription> filteringAcceptor;

        public void init(EObject target) {
        }

        public void init(EObject target, String expectedLabel, final IAcceptor<IReferenceDescription> acceptor) {
            this.targetURIs = this.getTargetURIs(target);
            this.filter = this.getFilter(target);
            FindReferencesTestUtil.assertEquals((Object)expectedLabel, (Object)this.getLabel(target));
            this.filteringAcceptor = new IAcceptor<IReferenceDescription>(){

                public void accept(IReferenceDescription t) {
                    if (filter.apply((Object)t)) {
                        acceptor.accept((Object)t);
                    }
                }
            };
            this.localResourceAccess = (ResourceAccess)this.resourceAccessProvider.get();
            this.localResourceAccess.registerResourceSet(target.eResource().getResourceSet());
        }

        public void execute() {
            this.referenceFinder.findAllReferences(this.targetURIs, (IReferenceFinder.ILocalResourceAccess)this.localResourceAccess, this.filteringAcceptor, null);
        }
    }

    public static class MockAcceptor
    implements IAcceptor<IReferenceDescription> {
        private Queue<IReferenceDescription> expectationQueue = Lists.newLinkedList();

        public void expect(EObject from, EObject to, EReference eReference) {
            this.expectationQueue.add((IReferenceDescription)new DefaultReferenceDescription(from, to, eReference, 0, null));
        }

        public void assertFinished() {
            IReferenceDescription nextExpected = this.expectationQueue.poll();
            if (nextExpected != null) {
                FindReferencesTestUtil.fail((String)("Expected " + this.toString(nextExpected)));
            }
        }

        private String toString(IReferenceDescription rd) {
            return String.valueOf(rd.getSourceEObjectUri()) + " ---" + rd.getEReference().getName() + "---> " + String.valueOf(rd.getTargetEObjectUri());
        }

        private String toString(IReferenceDescription expected, IReferenceDescription actual) {
            return "Expected: \n" + this.toString(expected) + "\n but got:\n" + this.toString(actual) + "\n queueSize=" + this.expectationQueue.size() + "\n";
        }

        public void accept(IReferenceDescription description) {
            IReferenceDescription nextExpected = this.expectationQueue.poll();
            FindReferencesTestUtil.assertNotNull((Object)nextExpected);
            FindReferencesTestUtil.assertEquals((String)this.toString(nextExpected, description), (Object)nextExpected.getSourceEObjectUri(), (Object)description.getSourceEObjectUri());
            FindReferencesTestUtil.assertEquals((String)this.toString(nextExpected, description), (Object)nextExpected.getTargetEObjectUri(), (Object)description.getTargetEObjectUri());
            FindReferencesTestUtil.assertEquals((String)this.toString(nextExpected, description), (Object)nextExpected.getEReference(), (Object)description.getEReference());
        }
    }
}

