/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

@Singleton
public class ReferencedInvalidTypeFinder
extends TypeReferenceVisitorWithResult<LightweightTypeReference> {
    @Inject
    private CommonTypeComputationServices services;

    public LightweightTypeReference findReferencedInvalidType(JvmIdentifiableElement element) {
        return this.internalFindReferencedInvalidType(element);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmIdentifiableElement field) {
        return null;
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(Void field) {
        return null;
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmField field) {
        JvmTypeReference _type = field.getType();
        LightweightTypeReference type = this.toLightweightTypeReference(_type);
        boolean _isPrimitiveVoid = type.isPrimitiveVoid();
        if (_isPrimitiveVoid) {
            return type;
        }
        return this.findUnknownType(type);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmOperation operation) {
        JvmTypeReference _returnType = operation.getReturnType();
        LightweightTypeReference unknownType = this.findUnknownType(_returnType);
        if (unknownType != null) {
            return unknownType;
        }
        return this._internalFindReferencedInvalidType((JvmExecutable)operation);
    }

    protected LightweightTypeReference _internalFindReferencedInvalidType(JvmExecutable executable) {
        LightweightTypeReference unknownType;
        EList _typeParameters = executable.getTypeParameters();
        Functions.Function1<JvmTypeParameter, EList<JvmTypeConstraint>> _function = new Functions.Function1<JvmTypeParameter, EList<JvmTypeConstraint>>(){

            public EList<JvmTypeConstraint> apply(JvmTypeParameter it) {
                return it.getConstraints();
            }
        };
        List _map = ListExtensions.map((List)_typeParameters, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        Functions.Function1<JvmTypeConstraint, JvmTypeReference> _function_1 = new Functions.Function1<JvmTypeConstraint, JvmTypeReference>(){

            public JvmTypeReference apply(JvmTypeConstraint it) {
                return it.getTypeReference();
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)_flatten, (Functions.Function1)_function_1);
        for (JvmTypeReference typeReference : _map_1) {
            LightweightTypeReference unknownType2 = this.findUnknownType(typeReference);
            if (unknownType2 == null) continue;
            return unknownType2;
        }
        EList _parameters = executable.getParameters();
        Functions.Function1<JvmFormalParameter, LightweightTypeReference> _function_2 = new Functions.Function1<JvmFormalParameter, LightweightTypeReference>(){

            public LightweightTypeReference apply(JvmFormalParameter it) {
                JvmTypeReference _parameterType = it.getParameterType();
                return ReferencedInvalidTypeFinder.this.toLightweightTypeReference(_parameterType);
            }
        };
        List _map_2 = ListExtensions.map((List)_parameters, (Functions.Function1)_function_2);
        for (LightweightTypeReference parameterType : _map_2) {
            boolean _isPrimitiveVoid = parameterType.isPrimitiveVoid();
            if (_isPrimitiveVoid) {
                return parameterType;
            }
            unknownType = this.findUnknownType(parameterType);
            if (unknownType == null) continue;
            return unknownType;
        }
        EList _exceptions = executable.getExceptions();
        for (JvmTypeReference exception : _exceptions) {
            unknownType = this.findUnknownType(exception);
            if (unknownType == null) continue;
            return unknownType;
        }
        return null;
    }

    protected LightweightTypeReference findUnknownType(JvmTypeReference reference) {
        LightweightTypeReference _lightweightTypeReference = this.toLightweightTypeReference(reference);
        return this.findUnknownType(_lightweightTypeReference);
    }

    protected LightweightTypeReference findUnknownType(LightweightTypeReference type) {
        return type.accept(this);
    }

    @Override
    protected LightweightTypeReference doVisitTypeReference(LightweightTypeReference reference) {
        boolean _isUnknown = reference.isUnknown();
        if (_isUnknown) {
            return reference;
        }
        return null;
    }

    @Override
    protected LightweightTypeReference doVisitArrayTypeReference(ArrayTypeReference reference) {
        LightweightTypeReference _componentType = reference.getComponentType();
        return _componentType.accept(this);
    }

    @Override
    protected LightweightTypeReference doVisitWildcardTypeReference(WildcardTypeReference reference) {
        List<LightweightTypeReference> _upperBounds = reference.getUpperBounds();
        LightweightTypeReference unknownType = this.visit(_upperBounds);
        if (unknownType != null) {
            return unknownType;
        }
        LightweightTypeReference lowerBound = reference.getLowerBound();
        if (lowerBound != null) {
            return lowerBound.accept(this);
        }
        return null;
    }

    @Override
    protected LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
        List<LightweightTypeReference> _typeArguments = reference.getTypeArguments();
        return this.visit(_typeArguments);
    }

    @Override
    protected LightweightTypeReference doVisitCompoundTypeReference(CompoundTypeReference reference) {
        List<LightweightTypeReference> _multiTypeComponents = reference.getMultiTypeComponents();
        return this.visit(_multiTypeComponents);
    }

    protected LightweightTypeReference visit(List<LightweightTypeReference> references) {
        Functions.Function1<LightweightTypeReference, LightweightTypeReference> _function = new Functions.Function1<LightweightTypeReference, LightweightTypeReference>(){

            public LightweightTypeReference apply(LightweightTypeReference it) {
                return it.accept(ReferencedInvalidTypeFinder.this);
            }
        };
        List _map = ListExtensions.map(references, (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        return (LightweightTypeReference)IterableExtensions.head((Iterable)_filterNull);
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef) {
        StandardTypeReferenceOwner _standardTypeReferenceOwner = new StandardTypeReferenceOwner(this.services, (EObject)typeRef);
        return _standardTypeReferenceOwner.toLightweightTypeReference(typeRef);
    }

    protected LightweightTypeReference internalFindReferencedInvalidType(JvmIdentifiableElement operation) {
        if (operation instanceof JvmOperation) {
            return this._internalFindReferencedInvalidType((JvmOperation)operation);
        }
        if (operation instanceof JvmExecutable) {
            return this._internalFindReferencedInvalidType((JvmExecutable)operation);
        }
        if (operation instanceof JvmField) {
            return this._internalFindReferencedInvalidType((JvmField)operation);
        }
        if (operation != null) {
            return this._internalFindReferencedInvalidType(operation);
        }
        if (operation == null) {
            return this._internalFindReferencedInvalidType((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(operation).toString());
    }
}

