/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.mediawiki.Template;
import org.eclipse.mylyn.wikitext.mediawiki.TemplateResolver;
import org.eclipse.mylyn.wikitext.mediawiki.internal.AbstractMediaWikiLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.internal.BuiltInTemplateResolver;
import org.eclipse.mylyn.wikitext.mediawiki.internal.MediaWikiIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.BehaviorSwitchBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.CommentBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.EscapeBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.HeadingBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.ListBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.PreformattedBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.SourceBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.TableBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.block.TableOfContentsBlock;
import org.eclipse.mylyn.wikitext.mediawiki.internal.phrase.EscapePhraseModifier;
import org.eclipse.mylyn.wikitext.mediawiki.internal.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.wikitext.mediawiki.internal.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.mediawiki.internal.token.HyperlinkExternalReplacementToken;
import org.eclipse.mylyn.wikitext.mediawiki.internal.token.HyperlinkInternalReplacementToken;
import org.eclipse.mylyn.wikitext.mediawiki.internal.token.ImageReplacementToken;
import org.eclipse.mylyn.wikitext.mediawiki.internal.token.LineBreakToken;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.phrase.HtmlCommentPhraseModifier;
import org.eclipse.mylyn.wikitext.parser.markup.phrase.LimitedHtmlEndTagPhraseModifier;
import org.eclipse.mylyn.wikitext.parser.markup.phrase.LimitedHtmlStartTagPhraseModifier;
import org.eclipse.mylyn.wikitext.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.parser.markup.token.PatternLiteralReplacementToken;

public class MediaWikiLanguage
extends AbstractMediaWikiLanguage {
    private List<Template> templates = new ArrayList<Template>();
    private List<TemplateResolver> templateProviders = new ArrayList<TemplateResolver>();
    private String templateExcludes;

    public MediaWikiLanguage() {
        this.setName("MediaWiki");
        this.setInternalLinkPattern("/wiki/{0}");
        this.templateProviders.add(new BuiltInTemplateResolver());
    }

    public String toInternalHref(String pageName) {
        return super.mapPageNameToHref(pageName);
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return new MediaWikiIdGenerationStrategy();
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add(new HeadingBlock());
        blocks.add(new ListBlock());
        blocks.add(new TableBlock());
        if (this.hasPreformattedBlock()) {
            blocks.add(new PreformattedBlock());
        }
        blocks.add((Block)new SourceBlock());
        blocks.add(new TableOfContentsBlock());
        blocks.add(new EscapeBlock());
        blocks.add(new CommentBlock());
        blocks.add(new BehaviorSwitchBlock());
        for (Block block : blocks) {
            if (block instanceof ParagraphBlock || block instanceof CommentBlock) continue;
            paragraphBreakingBlocks.add(block);
        }
    }

    private boolean hasPreformattedBlock() {
        return this.configuration == null ? true : !this.configuration.isOptimizeForRepositoryUsage();
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        boolean escapingHtml;
        phraseModifierSyntax.add((PatternBasedElement)new EscapePhraseModifier());
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]=>])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''''", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("''", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.endGroup(")", 0);
        boolean bl = escapingHtml = this.configuration == null ? false : this.configuration.isEscapingHtmlAndXml();
        if (!escapingHtml) {
            String[] allowedHtmlTags = new String[]{"b", "big", "blockquote", "caption", "center", "cite", "code", "dd", "del", "div", "dl", "dt", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "ins", "li", "ol", "p", "pre", "rb", "rp", "rt", "ruby", "s", "small", "span", "strike", "strong", "sub", "sup", "table", "td", "th", "tr", "tt", "u", "ul", "var"};
            phraseModifierSyntax.add((PatternBasedElement)new LimitedHtmlEndTagPhraseModifier(allowedHtmlTags));
            phraseModifierSyntax.add((PatternBasedElement)new LimitedHtmlStartTagPhraseModifier(allowedHtmlTags));
            phraseModifierSyntax.add((PatternBasedElement)new HtmlCommentPhraseModifier());
        }
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new LineBreakToken());
        tokenSyntax.add((PatternBasedElement)new org.eclipse.mylyn.wikitext.parser.markup.token.EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new org.eclipse.mylyn.wikitext.parser.markup.token.EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new org.eclipse.mylyn.wikitext.parser.markup.token.EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new org.eclipse.mylyn.wikitext.parser.markup.token.EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new org.eclipse.mylyn.wikitext.parser.markup.token.EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new org.eclipse.mylyn.wikitext.parser.markup.token.EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new ImageReplacementToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkInternalReplacementToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkExternalReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new PatternLiteralReplacementToken("(?:(?<=^|\\w\\s)(----)(?=$|\\s\\w))", "<hr/>"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken());
    }

    protected Block createParagraphBlock() {
        ParagraphBlock paragraphBlock = new ParagraphBlock(this.hasPreformattedBlock());
        if (this.configuration != null && this.configuration.isNewlinesMustCauseLineBreak()) {
            paragraphBlock.setNewlinesCauseLineBreak(true);
        }
        return paragraphBlock;
    }

    @Override
    public List<Template> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<Template> templates) {
        if (templates == null) {
            throw new IllegalArgumentException();
        }
        this.templates = templates;
    }

    @Override
    public List<TemplateResolver> getTemplateProviders() {
        return this.templateProviders;
    }

    public void setTemplateProviders(List<TemplateResolver> templateProviders) {
        if (templateProviders == null) {
            throw new IllegalArgumentException();
        }
        this.templateProviders = templateProviders;
    }

    @Override
    public MarkupLanguage clone() {
        MediaWikiLanguage copy = (MediaWikiLanguage)super.clone();
        copy.templates = new ArrayList<Template>(this.templates);
        copy.templateProviders = new ArrayList<TemplateResolver>(this.templateProviders);
        copy.templateExcludes = this.templateExcludes;
        return copy;
    }

    public void setTemplateExcludes(String templateExcludes) {
        this.templateExcludes = templateExcludes;
    }

    @Override
    public String getTemplateExcludes() {
        return this.templateExcludes;
    }
}

