/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.markdown;

import java.io.Writer;
import java.util.List;
import org.eclipse.mylyn.wikitext.markdown.internal.GfmIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.markdown.internal.MarkdownContentState;
import org.eclipse.mylyn.wikitext.markdown.internal.MarkdownDocumentBuilder;
import org.eclipse.mylyn.wikitext.markdown.internal.block.CodeBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.HeadingBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.HorizontalRuleBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.InlineHtmlBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.LinkDefinitionBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.ListBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.QuoteBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.block.UnderlinedHeadingBlock;
import org.eclipse.mylyn.wikitext.markdown.internal.phrase.BackslashEscapePhraseModifier;
import org.eclipse.mylyn.wikitext.markdown.internal.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.wikitext.markdown.internal.phrase.SimpleWordModifier;
import org.eclipse.mylyn.wikitext.markdown.internal.token.AutomaticLinkReplacementToken;
import org.eclipse.mylyn.wikitext.markdown.internal.token.InlineImageReplacementToken;
import org.eclipse.mylyn.wikitext.markdown.internal.token.InlineLinkReplacementToken;
import org.eclipse.mylyn.wikitext.markdown.internal.token.PreserverHtmlEntityToken;
import org.eclipse.mylyn.wikitext.markdown.internal.token.ReferenceStyleImageReplacementToken;
import org.eclipse.mylyn.wikitext.markdown.internal.token.ReferenceStyleLinkReplacementToken;
import org.eclipse.mylyn.wikitext.markdown.internal.util.ReadAheadDispatcher;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.phrase.HtmlEndTagPhraseModifier;
import org.eclipse.mylyn.wikitext.parser.markup.phrase.HtmlStartTagPhraseModifier;
import org.eclipse.mylyn.wikitext.parser.markup.token.PatternLineBreakReplacementToken;

public class MarkdownLanguage
extends AbstractMarkupLanguage {
    public MarkdownLanguage() {
        this.setName("Markdown");
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new PreserverHtmlEntityToken());
        tokenSyntax.add((PatternBasedElement)new InlineLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new InlineImageReplacementToken());
        tokenSyntax.add((PatternBasedElement)new PatternLineBreakReplacementToken("( {2,})$"));
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.add((PatternBasedElement)new HtmlEndTagPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new HtmlStartTagPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new InlineImageReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ReferenceStyleImageReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new InlineLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new ReferenceStyleLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new AutomaticLinkReplacementToken());
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("**"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("__"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("~~"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("*"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("_"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("~"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("\\"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("`"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("{"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("}"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("["));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("]"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("("));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier(")"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("#"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("+"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("-"));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("."));
        phraseModifierSyntax.add((PatternBasedElement)new BackslashEscapePhraseModifier("!"));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("``", DocumentBuilder.SpanType.CODE));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("`", DocumentBuilder.SpanType.CODE));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("**", DocumentBuilder.SpanType.STRONG));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleWordModifier("__", DocumentBuilder.SpanType.STRONG));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("*", DocumentBuilder.SpanType.EMPHASIS));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleWordModifier("_", DocumentBuilder.SpanType.EMPHASIS));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("~~", DocumentBuilder.SpanType.DELETED));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("~", DocumentBuilder.SpanType.DELETED));
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        CodeBlock codeBlock = new CodeBlock();
        HorizontalRuleBlock horizontalRuleBlock = new HorizontalRuleBlock();
        HeadingBlock headingBlock = new HeadingBlock();
        InlineHtmlBlock inlineHtmlBlock = new InlineHtmlBlock();
        QuoteBlock quoteBlock = new QuoteBlock();
        ListBlock listBlock = new ListBlock();
        LinkDefinitionBlock linkDefinitionBlock = new LinkDefinitionBlock();
        blocks.add(codeBlock);
        blocks.add(horizontalRuleBlock);
        blocks.add(headingBlock);
        blocks.add(inlineHtmlBlock);
        blocks.add(quoteBlock);
        blocks.add(listBlock);
        blocks.add(linkDefinitionBlock);
        paragraphBreakingBlocks.add(horizontalRuleBlock);
        paragraphBreakingBlocks.add(headingBlock);
        paragraphBreakingBlocks.add(quoteBlock);
        paragraphBreakingBlocks.add(listBlock);
    }

    protected Block createParagraphBlock() {
        ParagraphBlock paragraphBlock = new ParagraphBlock();
        UnderlinedHeadingBlock headingBlock = new UnderlinedHeadingBlock();
        ReadAheadDispatcher readAheadBlock = new ReadAheadDispatcher(headingBlock, paragraphBlock);
        return readAheadBlock;
    }

    protected ContentState createState() {
        return new MarkdownContentState();
    }

    public DocumentBuilder createDocumentBuilder(Writer out, boolean formatting) {
        return new MarkdownDocumentBuilder(out);
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return new GfmIdGenerationStrategy();
    }
}

