/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.targlets.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.p2.Configuration;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;
import org.eclipse.oomph.setup.targlets.SetupTargletsPackage;
import org.eclipse.oomph.setup.targlets.TargletTask;
import org.eclipse.oomph.setup.targlets.provider.SetupTargletsEditPlugin;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargletTaskItemProvider
extends SetupTaskItemProvider {
    public TargletTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTargletURIsPropertyDescriptor(object);
            this.addOperatingSystemPropertyDescriptor(object);
            this.addWindowingSystemPropertyDescriptor(object);
            this.addArchitecturePropertyDescriptor(object);
            this.addLocalePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTargletURIsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_targletURIs_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_targletURIs_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__TARGLET_UR_IS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addOperatingSystemPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_operatingSystem_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_operatingSystem_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__OPERATING_SYSTEM, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return Configuration.Choices.forOS();
            }
        });
    }

    protected void addWindowingSystemPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_windowingSystem_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_windowingSystem_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__WINDOWING_SYSTEM, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return Configuration.Choices.forWS();
            }
        });
    }

    protected void addArchitecturePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_architecture_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_architecture_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__ARCHITECTURE, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return Configuration.Choices.forArch();
            }
        });
    }

    protected void addLocalePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_locale_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_locale_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__LOCALE, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){
            private static final String NL_EXTRA = "org.eclipse.pde.nl.extra";
            private LocaleItemLabelProvider labelProvider;

            public Collection<?> getChoiceOfValues(Object object) {
                LocaleItemLabelProvider labelProvider = this.getLabelProvider(object);
                Set<String> locales = labelProvider.getLocaleMap().keySet();
                return TargletTaskItemProvider.getChoices(locales.toArray(new String[locales.size()]), NL_EXTRA);
            }

            public LocaleItemLabelProvider getLabelProvider(Object object) {
                if (this.labelProvider == null) {
                    this.labelProvider = new LocaleItemLabelProvider(this.itemDelegator);
                }
                return this.labelProvider;
            }
        });
    }

    private static Set<String> getChoices(String[] values, String extraValuesPreference) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(values));
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.core");
        String extraValues = node.get(extraValuesPreference, null);
        if (!StringUtil.isEmpty((String)extraValues)) {
            StringTokenizer tokenizer = new StringTokenizer(extraValues, ",");
            while (tokenizer.hasMoreTokens()) {
                String extraValue = tokenizer.nextToken().trim();
                result.add(extraValue);
            }
        }
        return result;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SetupTargletsPackage.Literals.TARGLET_TASK__TARGLETS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/TargletTask"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        return this.getString("_UI_TargletTask_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TargletTask.class)) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(SetupTargletsPackage.Literals.TARGLET_TASK__TARGLETS, TargletFactory.eINSTANCE.createTarglet()));
    }

    public ResourceLocator getResourceLocator() {
        return SetupTargletsEditPlugin.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocaleItemLabelProvider
    implements IItemLabelProvider {
        private final AdapterFactoryItemDelegator itemDelegator;
        private Map<String, String> localeMap;

        public LocaleItemLabelProvider(AdapterFactoryItemDelegator itemDelegator) {
            this.itemDelegator = itemDelegator;
        }

        public Object getImage(Object object) {
            return this.itemDelegator.getImage(object);
        }

        public String getText(Object object) {
            return this.getLocaleMap().get(object);
        }

        public Map<String, String> getLocaleMap() {
            if (this.localeMap == null) {
                this.localeMap = new HashMap<String, String>();
                Locale[] localeArray = Locale.getAvailableLocales();
                int n = localeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Locale locale = localeArray[n2];
                    this.localeMap.put(locale.toString(), String.valueOf(locale.toString()) + " - " + locale.getDisplayName());
                    ++n2;
                }
            }
            return this.localeMap;
        }
    }
}

