/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.lang.reflect.Field;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.HelpSupport;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OomphDialog
extends TitleAreaDialog
implements HelpSupport.HelpProvider {
    private String title;
    private int width;
    private int height;
    private OomphUIPlugin plugin;
    private HelpSupport helpSupport;

    protected OomphDialog(Shell parentShell, String title, int width, int height, OomphUIPlugin plugin, boolean helpAvailable) {
        super(parentShell);
        this.setShellStyle(68848);
        this.title = title;
        this.width = width;
        this.height = height;
        this.plugin = plugin;
        if (helpAvailable) {
            this.helpSupport = new HelpSupport(this){

                protected void handleInactivity(Display display, boolean inactive) {
                    OomphDialog.this.handleInactivity(display, inactive);
                }
            };
        }
    }

    public final HelpSupport getHelpSupport() {
        return this.helpSupport;
    }

    @Override
    public String getHelpPath() {
        return null;
    }

    public boolean close() {
        if (this.helpSupport != null) {
            this.helpSupport.dispose();
            this.helpSupport = null;
        }
        return super.close();
    }

    public String getTitle() {
        return this.title;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void openTray(DialogTray tray) throws IllegalStateException, UnsupportedOperationException {
        super.openTray(tray);
        OomphDialog.hookTray((TrayDialog)this);
    }

    public void setTitleImage(Image newTitleImage) {
        super.setTitleImage(newTitleImage);
        OomphDialog.fixTitleImageLayout(this);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        OomphDialog.fixTitleImageLayout(this);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(this.getShellText());
        this.setTitle(this.title);
        this.setTitleImage(this.getDefaultImage(this.getImagePath()));
        this.setMessage(this.getDefaultMessage());
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.getContainerMargin();
        layout.marginHeight = this.getContainerMargin();
        layout.verticalSpacing = 0;
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createUI(container);
        if (this.getContainerMargin() == 0) {
            this.createSeparator(container);
        }
        shell.setActive();
        return area;
    }

    protected Button createCheckbox(Composite parent, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createHelpControl(Composite parent) {
        ToolBar toolBar = (ToolBar)super.createHelpControl(parent);
        if (this.helpSupport != null) {
            ToolItem helpButton = toolBar.getItems()[0];
            this.helpSupport.hook(helpButton);
        }
        this.createToolItemsForToolBar(toolBar);
        return toolBar;
    }

    protected void createToolItemsForToolBar(ToolBar toolBar) {
    }

    protected final ToolItem createToolItem(ToolBar toolBar, String label) {
        return this.createToolItem(toolBar, null, label);
    }

    protected final ToolItem createToolItem(ToolBar toolBar, String iconPath, String toolTip) {
        ToolItem toolItem = new ToolItem(toolBar, 8);
        if (iconPath == null) {
            toolItem.setText(toolTip);
        } else {
            Image image = this.getDefaultImage(iconPath);
            toolItem.setImage(image);
            toolItem.setToolTipText(toolTip);
        }
        return toolItem;
    }

    protected Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        return separator;
    }

    protected int getContainerMargin() {
        return 0;
    }

    protected abstract String getImagePath();

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getClass().getName();
        OomphUIPlugin plugin = this.plugin != null ? this.plugin : UIPlugin.INSTANCE;
        return plugin.getDialogSettings(sectionName);
    }

    protected void handleInactivity(Display display, boolean inactive) {
    }

    protected final Point getInitialSize() {
        return new Point(this.width, this.height);
    }

    protected final Image getDefaultImage(String path) {
        return this.plugin.getSWTImage(path);
    }

    protected abstract String getDefaultMessage();

    protected abstract String getShellText();

    protected abstract void createUI(Composite var1);

    public static void fixTitleImageLayout(TitleAreaDialog dialog) {
        try {
            Field titleImageLargestField = ReflectUtil.getField(TitleAreaDialog.class, (String)"titleImageLargest");
            boolean titleImageLargest = (Boolean)ReflectUtil.getValue((Field)titleImageLargestField, (Object)dialog);
            Field workAreaField = ReflectUtil.getField(TitleAreaDialog.class, (String)"workArea");
            Composite workArea = (Composite)ReflectUtil.getValue((Field)workAreaField, (Object)dialog);
            Field titleImageLabelField = ReflectUtil.getField(TitleAreaDialog.class, (String)"titleImageLabel");
            Label titleImageLabel = (Label)ReflectUtil.getValue((Field)titleImageLabelField, (Object)dialog);
            FormData layoutData = (FormData)titleImageLabel.getLayoutData();
            if (titleImageLargest) {
                layoutData.top = new FormAttachment(0, 0);
                layoutData.bottom = null;
            } else {
                layoutData.top = null;
                layoutData.bottom = new FormAttachment((Control)workArea);
            }
        }
        catch (Throwable throwable) {}
    }

    public static void hookTray(final TrayDialog dialog) throws IllegalStateException, UnsupportedOperationException {
        Control trayControl = (Control)OomphDialog.getFieldValue(dialog, "trayControl");
        final Label rightSeparator = (Label)OomphDialog.getFieldValue(dialog, "rightSeparator");
        final Sash sash = (Sash)OomphDialog.getFieldValue(dialog, "sash");
        if (trayControl == null || rightSeparator == null || sash == null) {
            return;
        }
        final GridData data = (GridData)trayControl.getLayoutData();
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 1) {
                    Shell shell = dialog.getShell();
                    Rectangle clientArea = shell.getClientArea();
                    int newWidth = clientArea.width - event.x - (sash.getSize().x + rightSeparator.getSize().x);
                    if (newWidth != data.widthHint) {
                        data.widthHint = newWidth;
                        shell.layout();
                    }
                }
            }
        });
    }

    private static <T> T getFieldValue(TrayDialog dialog, String name) {
        try {
            Field field = ReflectUtil.getField(TrayDialog.class, (String)name);
            if (field != null) {
                Object value = ReflectUtil.getValue((Field)field, (Object)dialog);
                return (T)value;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

