/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private boolean showProfiles;

    public boolean isShowProfiles() {
        return this.showProfiles;
    }

    public void setShowProfiles(boolean showProfiles) {
        this.showProfiles = showProfiles;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length != 0;
    }

    public Object[] getChildren(Object element) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (element instanceof AgentManager) {
            AgentManager agentManager = (AgentManager)element;
            this.addChildrenOfAgentManager(agentManager, children);
        }
        if (element instanceof Agent) {
            Agent agent = (Agent)element;
            this.addChildrenOfAgent(agent, children);
        }
        if (element instanceof BundlePool) {
            BundlePool bundlePool = (BundlePool)element;
            this.addChildrenOfBundlePool(bundlePool, children);
        }
        return children.toArray();
    }

    protected void addChildrenOfAgentManager(AgentManager agentManager, List<Object> children) {
        children.addAll(agentManager.getAgents());
    }

    protected void addChildrenOfAgent(Agent agent, List<Object> children) {
        children.addAll(agent.getBundlePools());
        if (this.showProfiles) {
            children.addAll(agent.getProfiles());
        }
    }

    protected void addChildrenOfBundlePool(BundlePool bundlePool, List<Object> children) {
        if (this.showProfiles) {
            children.addAll(bundlePool.getProfiles());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllBundlePools
    extends P2ContentProvider {
        @Override
        protected void addChildrenOfAgentManager(AgentManager agentManager, List<Object> children) {
            children.addAll(agentManager.getBundlePools());
        }
    }
}

