/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushDirectAction
implements IObjectActionDelegate {
    private Repository repository;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.repository = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Object element = ssel.getFirstElement();
            this.repository = PushDirectAction.getAdapter(element, Repository.class);
        }
    }

    public void run(IAction action) {
        if (this.repository != null) {
            new Job("Pushing directly"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(this.getName(), 101);
                    try {
                        Git git = Git.wrap((Repository)PushDirectAction.this.repository);
                        monitor.worked(1);
                        git.push().setRemote("direct").setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)new SubProgressMonitor(monitor, 50))).call();
                        monitor.setTaskName("Pulling");
                        git.pull().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)new SubProgressMonitor(monitor, 50))).call();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Exception ex) {
                        IStatus iStatus = SetupEditorPlugin.getStatus(ex);
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            }.schedule();
        }
    }

    private static <T> T getAdapter(Object adaptable, Class<T> c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return (T)adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return (T)adapter;
        }
        return null;
    }
}

