/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.File;
import java.net.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;

public class CacheUsageConfirmerUI
extends CacheUsageConfirmer {
    private Boolean cacheUsageConfirmed;

    public boolean confirmCacheUsage(final URI uri, File file) {
        if (this.cacheUsageConfirmed == null) {
            Shell shell;
            this.cacheUsageConfirmed = Boolean.FALSE;
            final long lastModified = file.lastModified();
            if (lastModified != 0L && (shell = this.getShell()) != null) {
                UIUtil.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        long minutes;
                        long hours;
                        long age = System.currentTimeMillis() - lastModified;
                        long days = age / 86400000L;
                        String message = days > 0L ? String.valueOf(days) + " days" : ((hours = age / 3600000L) > 0L ? String.valueOf(hours) + " hours" : ((minutes = age / 60000L) > 0L ? String.valueOf(minutes) + " minutes" : "a few seconds "));
                        CacheUsageConfirmerUI.this.cacheUsageConfirmed = MessageDialog.openQuestion((Shell)shell, (String)"Download failure", (String)("The following URI could not be downloaded:\n\n  " + uri + "\n\nA locally cached version that is " + message + " old is available.  Would you like to use locally cached versions, when available, to continue provisioning?"));
                    }
                });
            }
        }
        return this.cacheUsageConfirmed;
    }

    public void reset() {
        this.cacheUsageConfirmed = null;
    }

    protected Shell getShell() {
        try {
            return UIUtil.getShell();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

